/*
 * Decompiled with CFR 0.152.
 */
package internal.sdmxdl.ri.file;

import internal.sdmxdl.ri.file.SdmxDecoder;
import java.io.IOException;
import lombok.Generated;
import lombok.NonNull;
import nbbrd.io.xml.Xml;
import org.checkerframework.checker.nullness.qual.Nullable;
import sdmxdl.DataCursor;
import sdmxdl.DataFilter;
import sdmxdl.DataStructure;
import sdmxdl.DataflowRef;
import sdmxdl.Key;
import sdmxdl.LanguagePriorityList;
import sdmxdl.ext.ObsFactory;
import sdmxdl.file.SdmxFileListener;
import sdmxdl.file.SdmxFileSource;
import sdmxdl.util.file.SdmxFileClient;
import sdmxdl.util.file.SdmxFileInfo;
import sdmxdl.util.parser.ObsFactories;
import sdmxdl.xml.stream.SdmxXmlStreams;

public class XmlFileClient
implements SdmxFileClient {
    @NonNull
    private final SdmxFileSource source;
    @NonNull
    private final LanguagePriorityList languages;
    @NonNull
    private final SdmxDecoder decoder;
    private final @Nullable ObsFactory obsFactory;
    @NonNull
    SdmxFileListener eventListener;

    public SdmxFileInfo decode() throws IOException {
        return this.decoder.decode(this.source, this.languages);
    }

    public DataCursor loadData(SdmxFileInfo info, DataflowRef flowRef, Key key, DataFilter filter) throws IOException {
        if (this.eventListener.isEnabled()) {
            this.eventListener.onFileSourceEvent(this.source, "Loading data from file '" + this.source.getData() + "'");
        }
        return ((DataCursor)this.getDataSupplier(info.getDataType(), info.getStructure()).parseFile(this.source.getData())).filter(key, filter);
    }

    private Xml.Parser<DataCursor> getDataSupplier(String dataType, DataStructure dsd) throws IOException {
        switch (dataType) {
            case "application/vnd.sdmx.genericdata+xml;version=2.0": {
                return SdmxXmlStreams.genericData20((DataStructure)dsd, (ObsFactory)(this.obsFactory != null ? this.obsFactory : ObsFactories.SDMX20));
            }
            case "application/vnd.sdmx.structurespecificdata+xml;version=2.0": {
                return SdmxXmlStreams.compactData20((DataStructure)dsd, (ObsFactory)(this.obsFactory != null ? this.obsFactory : ObsFactories.SDMX20));
            }
            case "application/vnd.sdmx.genericdata+xml;version=2.1": {
                return SdmxXmlStreams.genericData21((DataStructure)dsd, (ObsFactory)(this.obsFactory != null ? this.obsFactory : ObsFactories.SDMX21));
            }
            case "application/vnd.sdmx.structurespecificdata+xml;version=2.1": {
                return SdmxXmlStreams.compactData21((DataStructure)dsd, (ObsFactory)(this.obsFactory != null ? this.obsFactory : ObsFactories.SDMX21));
            }
        }
        throw new IOException("Don't known how to handle type '" + dataType + "'");
    }

    @Generated
    public XmlFileClient(@NonNull SdmxFileSource source, @NonNull LanguagePriorityList languages, @NonNull SdmxDecoder decoder, @Nullable ObsFactory obsFactory, @NonNull SdmxFileListener eventListener) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (languages == null) {
            throw new NullPointerException("languages is marked non-null but is null");
        }
        if (decoder == null) {
            throw new NullPointerException("decoder is marked non-null but is null");
        }
        if (eventListener == null) {
            throw new NullPointerException("eventListener is marked non-null but is null");
        }
        this.source = source;
        this.languages = languages;
        this.decoder = decoder;
        this.obsFactory = obsFactory;
        this.eventListener = eventListener;
    }
}

