/*
 * Decompiled with CFR 0.152.
 */
package internal.sdmxdl.ri.file;

import internal.sdmxdl.ri.file.DataStructureDecoder;
import internal.sdmxdl.ri.file.SdmxDecoder;
import java.io.File;
import java.io.IOException;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import nbbrd.io.xml.Xml;
import sdmxdl.DataStructure;
import sdmxdl.LanguagePriorityList;
import sdmxdl.file.SdmxFileListener;
import sdmxdl.file.SdmxFileSource;
import sdmxdl.util.file.SdmxFileInfo;
import sdmxdl.xml.SdmxmlDataTypeProbe;
import sdmxdl.xml.XmlFileSource;
import sdmxdl.xml.stream.SdmxXmlStreams;

public final class XmlDecoder
implements SdmxDecoder {
    @NonNull
    private final SdmxFileListener eventListener;

    @Override
    public SdmxFileInfo decode(SdmxFileSource source, LanguagePriorityList langs) throws IOException {
        String type = this.probeDataType(source);
        return SdmxFileInfo.of((String)type, (DataStructure)this.loadStructure(source, langs, type));
    }

    private String probeDataType(SdmxFileSource source) throws IOException {
        if (this.eventListener.isEnabled()) {
            this.eventListener.onFileSourceEvent(source, "Probing data type from '" + source.getData() + "'");
        }
        return (String)SdmxmlDataTypeProbe.of().parseFile(source.getData());
    }

    private DataStructure loadStructure(SdmxFileSource source, LanguagePriorityList langs, String type) throws IOException {
        return XmlFileSource.isValidFile((File)source.getStructure()) ? this.parseStruct(type, langs, source) : this.decodeStruct(type, source);
    }

    private DataStructure parseStruct(String dataType, LanguagePriorityList langs, SdmxFileSource source) throws IOException {
        if (this.eventListener.isEnabled()) {
            this.eventListener.onFileSourceEvent(source, "Parsing structure from '" + source.getStructure() + "' with data type '" + dataType + "'");
        }
        return (DataStructure)((List)this.getStructParser(dataType, langs).parseFile(source.getStructure())).stream().findFirst().orElseThrow(IOException::new);
    }

    private Xml.Parser<List<DataStructure>> getStructParser(String dataType, LanguagePriorityList langs) throws IOException {
        switch (dataType) {
            case "application/vnd.sdmx.genericdata+xml;version=2.0": 
            case "application/vnd.sdmx.structurespecificdata+xml;version=2.0": {
                return SdmxXmlStreams.struct20((LanguagePriorityList)langs);
            }
            case "application/vnd.sdmx.genericdata+xml;version=2.1": 
            case "application/vnd.sdmx.structurespecificdata+xml;version=2.1": {
                return SdmxXmlStreams.struct21((LanguagePriorityList)langs);
            }
        }
        throw new IOException("Don't know how to handle '" + dataType + "'");
    }

    private DataStructure decodeStruct(String dataType, SdmxFileSource source) throws IOException {
        if (this.eventListener.isEnabled()) {
            this.eventListener.onFileSourceEvent(source, "Decoding structure from '" + source.getData() + "' with data type '" + dataType + "'");
        }
        return (DataStructure)XmlDecoder.getStructDecoder(dataType).parseFile(source.getData());
    }

    private static Xml.Parser<DataStructure> getStructDecoder(String o) throws IOException {
        switch (o) {
            case "application/vnd.sdmx.genericdata+xml;version=2.0": {
                return DataStructureDecoder.generic20();
            }
            case "application/vnd.sdmx.structurespecificdata+xml;version=2.0": {
                return DataStructureDecoder.compact20();
            }
            case "application/vnd.sdmx.genericdata+xml;version=2.1": {
                return DataStructureDecoder.generic21();
            }
            case "application/vnd.sdmx.structurespecificdata+xml;version=2.1": {
                return DataStructureDecoder.compact21();
            }
        }
        throw new IOException("Don't know how to handle '" + o + "'");
    }

    @Generated
    public XmlDecoder(@NonNull SdmxFileListener eventListener) {
        if (eventListener == null) {
            throw new NullPointerException("eventListener is marked non-null but is null");
        }
        this.eventListener = eventListener;
    }
}

