/*
 * Decompiled with CFR 0.152.
 */
package internal.sdmxdl.ri.file;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import sdmxdl.Codelist;
import sdmxdl.CodelistRef;
import sdmxdl.DataStructure;
import sdmxdl.DataStructureRef;
import sdmxdl.Dimension;

final class CustomDataStructureBuilder {
    private final LinkedHashMap<String, Set<String>> dimensions = new LinkedHashMap();
    private final LinkedHashMap<String, Set<String>> attributes = new LinkedHashMap();
    private String fileType = null;
    private DataStructureRef ref = null;
    private String timeDimensionId = null;
    private String primaryMeasureId = null;
    private static final Pattern WHITE_SPACE_PATTERN = Pattern.compile("\\s+");

    CustomDataStructureBuilder() {
    }

    public @NonNull CustomDataStructureBuilder dimension(@NonNull String concept, @NonNull String value) {
        CustomDataStructureBuilder.putMulti(this.dimensions, concept, value);
        return this;
    }

    public @NonNull CustomDataStructureBuilder attribute(@NonNull String concept, @NonNull String value) {
        CustomDataStructureBuilder.putMulti(this.attributes, concept, value);
        return this;
    }

    public @NonNull CustomDataStructureBuilder fileType(@NonNull String fileType) {
        this.fileType = fileType;
        return this;
    }

    public @NonNull CustomDataStructureBuilder refId(@NonNull String refId) {
        return this.ref(DataStructureRef.of(null, (String)refId, null));
    }

    public @NonNull CustomDataStructureBuilder ref(@NonNull DataStructureRef ref) {
        this.ref = ref;
        return this;
    }

    public @NonNull CustomDataStructureBuilder timeDimensionId(@Nullable String timeDimensionId) {
        this.timeDimensionId = timeDimensionId;
        return this;
    }

    public @NonNull CustomDataStructureBuilder primaryMeasureId(@Nullable String primaryMeasureId) {
        this.primaryMeasureId = primaryMeasureId;
        return this;
    }

    public @NonNull DataStructure build() {
        return DataStructure.builder().ref(this.ref).dimensions(this.guessDimensions()).label(this.ref.getId()).timeDimensionId(this.timeDimensionId != null ? this.timeDimensionId : "TIME_PERIOD").primaryMeasureId(this.primaryMeasureId != null ? this.primaryMeasureId : "OBS_VALUE").build();
    }

    private Set<Dimension> guessDimensions() {
        LinkedHashSet<Dimension> result = new LinkedHashSet<Dimension>();
        int position = 1;
        boolean needsFiltering = this.fileType.equals("application/vnd.sdmx.structurespecificdata+xml;version=2.0") || this.fileType.equals("application/vnd.sdmx.structurespecificdata+xml;version=2.1");
        for (Map.Entry<String, Set<String>> item : this.dimensions.entrySet()) {
            if (needsFiltering && this.isAttribute(item)) continue;
            result.add(CustomDataStructureBuilder.dimension(item.getKey(), position++, (Collection<String>)item.getValue()));
        }
        return result;
    }

    private boolean isAttribute(Map.Entry<String, Set<String>> item) {
        if (item.getKey().contains("TITLE")) {
            return true;
        }
        return item.getValue().stream().anyMatch(o -> WHITE_SPACE_PATTERN.matcher((CharSequence)o).find());
    }

    private static void putMulti(Map<String, Set<String>> map, String key, String value) {
        map.computeIfAbsent(key, k -> new HashSet()).add(value);
    }

    static Dimension dimension(String name, int pos, String ... values) {
        return CustomDataStructureBuilder.dimension(name, pos, Arrays.asList(values));
    }

    static Dimension dimension(String name, int pos, Collection<String> values) {
        Codelist.Builder codelist = Codelist.builder().ref(CodelistRef.parse((CharSequence)name));
        values.forEach(o -> codelist.code(o, o));
        return Dimension.builder().id(name).position(pos).label(name).codelist(codelist.build()).build();
    }
}

