package internal.util.http;

import java.lang.Iterable;
import java.lang.Long;
import java.lang.Override;
import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.StreamSupport;

/**
 * Custom service loader for {@link internal.util.http.HttpURLConnectionFactory}.
 * <br>This class is thread-safe.
 * <p>Properties:
 * <ul>
 * <li>Quantifier: SINGLE</li>
 * <li>Fallback: {@link internal.util.http.DefaultHttpURLConnectionFactory}</li>
 * <li>Preprocessing: wrapper: none filters:[isRequired] sorters:[]</li>
 * <li>Mutability: NONE</li>
 * <li>Singleton: true</li>
 * <li>Name: null</li>
 * <li>Backend: null</li>
 * <li>Cleaner: null</li>
 * </ul>
 */
public final class HttpURLConnectionFactoryLoader {
  private static final Iterable SOURCE = ServiceLoader.load(HttpURLConnectionFactory.class);

  private static final HttpURLConnectionFactory RESOURCE = doLoad();

  private HttpURLConnectionFactoryLoader() {
  }

  private static Spliterator<HttpURLConnectionFactory> spliterator() {
    return new Spliterators.AbstractSpliterator<HttpURLConnectionFactory>(Long.MAX_VALUE, 0) {
      final Iterator delegate = SOURCE.iterator();

      @Override
      public boolean tryAdvance(Consumer<? super HttpURLConnectionFactory> action) {
        if (delegate.hasNext()) {
          action.accept((HttpURLConnectionFactory) delegate.next());
          return true;
        }
        return false;
      }
    };
  }

  private static HttpURLConnectionFactory doLoad() {
    return StreamSupport.stream(spliterator(), false)
        .filter(HttpURLConnectionFactory::isRequired)
        .findFirst()
        .orElseGet(() -> new DefaultHttpURLConnectionFactory());
  }

  /**
   * Gets a {@link internal.util.http.HttpURLConnectionFactory} instance.
   * <br>This method is thread-safe.
   * @return the current non-null value
   */
  public static HttpURLConnectionFactory get() {
    return RESOURCE;
  }
}
