/*
 * Decompiled with CFR 0.152.
 */
package sdmxdl.format.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Locale;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import lombok.Generated;
import nbbrd.io.FileFormatter;
import nbbrd.io.FileParser;
import nbbrd.io.xml.Stax;
import sdmxdl.Confidentiality;
import sdmxdl.HasPersistence;
import sdmxdl.ext.FileFormat;
import sdmxdl.format.FileFormatSupport;
import sdmxdl.web.WebSource;
import sdmxdl.web.WebSources;

final class XmlWebSourcesFormat
implements FileFormat<WebSources> {
    public static final XmlWebSourcesFormat INSTANCE = new XmlWebSourcesFormat();
    private final FileFormat<WebSources> support = FileFormatSupport.builder(WebSources.class).parser((FileParser)Stax.StreamParser.valueOf(XmlWebSourcesFormat::parseXml)).formatter((FileFormatter)Stax.StreamFormatter.of(XmlWebSourcesFormat::formatXml)).extension(".xml").build();
    private static final String SOURCES_TAG = "sources";
    private static final String SOURCE_TAG = "source";
    private static final String NAME_TAG = "name";
    private static final String DESCRIPTION_TAG = "description";
    private static final String DRIVER_TAG = "driver";
    private static final String CONFIDENTIALITY_TAG = "confidentiality";
    private static final String ENDPOINT_TAG = "endpoint";
    private static final String PROPERTY_TAG = "property";
    private static final String ALIAS_TAG = "alias";
    private static final String WEBSITE_TAG = "website";
    private static final String LANG_ATTR = "lang";
    private static final String KEY_ATTR = "key";
    private static final String VALUE_ATTR = "value";
    private static final String MONITOR_TAG = "monitor";
    private static final String MONITOR_WEBSITE_TAG = "monitorWebsite";
    private static final String ROOT_LANGUAGE = Locale.ROOT.getLanguage();

    XmlWebSourcesFormat() {
    }

    private static WebSources parseXml(XMLStreamReader reader) throws XMLStreamException {
        WebSources.Builder result = WebSources.builder();
        WebSource.Builder item = WebSource.builder();
        while (reader.hasNext()) {
            block0 : switch (reader.next()) {
                case 1: {
                    switch (reader.getLocalName()) {
                        case "source": {
                            item = WebSource.builder();
                            break block0;
                        }
                        case "name": {
                            item.id(reader.getElementText());
                            break block0;
                        }
                        case "description": {
                            String lang = reader.getAttributeValue(null, LANG_ATTR);
                            item.name(lang != null ? lang : ROOT_LANGUAGE, reader.getElementText());
                            break block0;
                        }
                        case "driver": {
                            item.driver(reader.getElementText());
                            break block0;
                        }
                        case "confidentiality": {
                            item.confidentiality(Confidentiality.valueOf((String)reader.getElementText()));
                            break block0;
                        }
                        case "endpoint": {
                            item.endpointOf((CharSequence)reader.getElementText());
                            break block0;
                        }
                        case "property": {
                            item.property(reader.getAttributeValue(null, KEY_ATTR), reader.getAttributeValue(null, VALUE_ATTR));
                            break block0;
                        }
                        case "alias": {
                            item.alias(reader.getElementText());
                            break block0;
                        }
                        case "website": {
                            item.websiteOf((CharSequence)reader.getElementText());
                            break block0;
                        }
                        case "monitor": {
                            item.monitorOf((CharSequence)reader.getElementText());
                            break block0;
                        }
                        case "monitorWebsite": {
                            item.monitorWebsiteOf((CharSequence)reader.getElementText());
                        }
                    }
                    break;
                }
                case 2: {
                    switch (reader.getLocalName()) {
                        case "source": {
                            result.source(item.build());
                        }
                    }
                }
            }
        }
        return result.build();
    }

    private static void formatXml(WebSources list, XMLStreamWriter writer, Charset encoding) throws XMLStreamException {
        writer.writeStartDocument(encoding.name(), "1.0");
        writer.writeStartElement(SOURCES_TAG);
        for (WebSource source : list.getSources()) {
            writer.writeStartElement(SOURCE_TAG);
            XmlWebSourcesFormat.writeTextElement(writer, NAME_TAG, source.getId());
            for (Map.Entry<String, String> entry : source.getNames().entrySet()) {
                XmlWebSourcesFormat.writeDescription(writer, entry);
            }
            XmlWebSourcesFormat.writeTextElement(writer, DRIVER_TAG, source.getDriver());
            if (source.getConfidentiality() != Confidentiality.RESTRICTED) {
                XmlWebSourcesFormat.writeTextElement(writer, CONFIDENTIALITY_TAG, source.getConfidentiality());
            }
            XmlWebSourcesFormat.writeTextElement(writer, ENDPOINT_TAG, source.getEndpoint().toString());
            for (Map.Entry<String, String> entry : source.getProperties().entrySet()) {
                XmlWebSourcesFormat.writeProperty(writer, entry);
            }
            for (String string : source.getAliases()) {
                XmlWebSourcesFormat.writeTextElement(writer, ALIAS_TAG, string);
            }
            XmlWebSourcesFormat.writeTextElement(writer, WEBSITE_TAG, source.getWebsite());
            XmlWebSourcesFormat.writeTextElement(writer, MONITOR_TAG, source.getMonitor());
            XmlWebSourcesFormat.writeTextElement(writer, MONITOR_WEBSITE_TAG, source.getMonitorWebsite());
            writer.writeEndElement();
        }
        writer.writeEndElement();
        writer.writeEndDocument();
    }

    private static void writeDescription(XMLStreamWriter writer, Map.Entry<String, String> description) throws XMLStreamException {
        writer.writeStartElement(DESCRIPTION_TAG);
        String lang = description.getKey();
        if (!lang.isEmpty()) {
            writer.writeAttribute(LANG_ATTR, lang);
        }
        writer.writeCharacters(description.getValue());
        writer.writeEndElement();
    }

    private static void writeProperty(XMLStreamWriter writer, Map.Entry<String, String> property) throws XMLStreamException {
        writer.writeStartElement(PROPERTY_TAG);
        writer.writeAttribute(KEY_ATTR, property.getKey());
        writer.writeAttribute(VALUE_ATTR, property.getValue());
        writer.writeEndElement();
    }

    private static void writeTextElement(XMLStreamWriter writer, String name, Object value) throws XMLStreamException {
        if (value != null) {
            writer.writeStartElement(name);
            writer.writeCharacters(value.toString());
            writer.writeEndElement();
        }
    }

    @Generated
    public WebSources parsePath(Path arg0) throws IOException {
        return (WebSources)this.support.parsePath(arg0);
    }

    @Generated
    public WebSources parseStream(InputStream arg0) throws IOException {
        return (WebSources)this.support.parseStream(arg0);
    }

    @Generated
    public void formatPath(WebSources arg0, Path arg1) throws IOException {
        this.support.formatPath((HasPersistence)arg0, arg1);
    }

    @Generated
    public void formatStream(WebSources arg0, OutputStream arg1) throws IOException {
        this.support.formatStream((HasPersistence)arg0, arg1);
    }

    @Generated
    public String getFileExtension() {
        return this.support.getFileExtension();
    }
}

