/*
 * Decompiled with CFR 0.152.
 */
package sdmxdl.format.xml;

import internal.sdmxdl.format.xml.Sdmxml;
import internal.sdmxdl.format.xml.XMLStreamUtil;
import java.net.URI;
import java.util.Optional;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import nbbrd.io.net.MediaType;
import nbbrd.io.xml.Stax;
import nbbrd.io.xml.Xml;
import sdmxdl.format.xml.XmlMediaTypes;

public final class XmlMediaTypeProbe {
    private static final MediaType UNSUPPORTED_TYPE = null;
    private static final MediaType UNKNOWN_TYPE = null;
    private static final String DATASET_TAG = "DataSet";
    private static final String SERIES_TAG = "Series";
    private static final String SERIES_KEY_TAG = "SeriesKey";

    public static Xml.Parser<Optional<MediaType>> of() {
        return Stax.StreamParser.valueOf(XmlMediaTypeProbe::probeDataType);
    }

    private static Optional<MediaType> probeDataType(XMLStreamReader reader) throws XMLStreamException {
        return Optional.ofNullable(XmlMediaTypeProbe.probeDataTypeOrNull(reader));
    }

    private static MediaType probeDataTypeOrNull(XMLStreamReader reader) throws XMLStreamException {
        if (XMLStreamUtil.isNotNamespaceAware(reader)) {
            throw new XMLStreamException("Cannot probe data type");
        }
        while (reader.hasNext()) {
            switch (reader.next()) {
                case 1: {
                    URI uri = URI.create(reader.getNamespaceURI());
                    if (Sdmxml.MESSAGE_V10.is(uri)) {
                        return UNSUPPORTED_TYPE;
                    }
                    if (Sdmxml.MESSAGE_V20.is(uri)) {
                        return XmlMediaTypeProbe.parse20(reader);
                    }
                    if (Sdmxml.MESSAGE_V21.is(uri)) {
                        return XmlMediaTypeProbe.parse21(reader);
                    }
                    return UNKNOWN_TYPE;
                }
            }
        }
        return null;
    }

    private static MediaType parse21(XMLStreamReader reader) throws XMLStreamException {
        while (reader.hasNext()) {
            switch (reader.next()) {
                case 1: {
                    if (!reader.getLocalName().equals(DATASET_TAG)) break;
                    return XmlMediaTypeProbe.parseDataSet21(reader);
                }
            }
        }
        return UNKNOWN_TYPE;
    }

    private static MediaType parseDataSet21(XMLStreamReader reader) throws XMLStreamException {
        while (reader.hasNext()) {
            switch (reader.next()) {
                case 1: {
                    if (!reader.getLocalName().equals(SERIES_TAG)) break;
                    return XmlMediaTypeProbe.hasSeriesKeyTag(reader) ? XmlMediaTypes.GENERIC_DATA_21 : XmlMediaTypes.STRUCTURE_SPECIFIC_DATA_21;
                }
            }
        }
        return UNKNOWN_TYPE;
    }

    private static MediaType parse20(XMLStreamReader reader) throws XMLStreamException {
        while (reader.hasNext()) {
            switch (reader.next()) {
                case 1: {
                    if (!reader.getLocalName().equals(DATASET_TAG)) break;
                    return XmlMediaTypeProbe.parseDataSet20(reader);
                }
            }
        }
        return UNKNOWN_TYPE;
    }

    private static MediaType parseDataSet20(XMLStreamReader reader) throws XMLStreamException {
        while (reader.hasNext()) {
            switch (reader.next()) {
                case 1: {
                    if (!reader.getLocalName().equals(SERIES_TAG)) break;
                    return XmlMediaTypeProbe.hasSeriesKeyTag(reader) ? XmlMediaTypes.GENERIC_DATA_20 : XmlMediaTypes.STRUCTURE_SPECIFIC_DATA_20;
                }
            }
        }
        return UNKNOWN_TYPE;
    }

    private static boolean hasSeriesKeyTag(XMLStreamReader reader) throws XMLStreamException {
        while (reader.hasNext()) {
            switch (reader.next()) {
                case 1: {
                    if (!reader.getLocalName().equals(SERIES_KEY_TAG)) break;
                    return true;
                }
                case 2: {
                    if (!reader.getLocalName().equals(SERIES_TAG)) break;
                    return false;
                }
            }
        }
        return false;
    }
}

