/*
 * Decompiled with CFR 0.152.
 */
package sdmxdl.format.xml;

import internal.sdmxdl.format.xml.ImmutableXMLInputFactory;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.file.Paths;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import lombok.Generated;
import nbbrd.io.xml.Stax;
import nbbrd.io.xml.Xml;
import sdmxdl.file.FileSource;

public final class XmlFileSource {
    private static final XMLOutputFactory OUTPUT = XMLOutputFactory.newInstance();
    private static final Xml.Formatter<FileSource> FORMATTER = Stax.StreamFormatter.builder().factory(() -> OUTPUT).handler2(XmlFileSource::formatXml).build();
    private static final Xml.Parser<FileSource> PARSER = Stax.StreamParser.builder().factory(ImmutableXMLInputFactory::getInputFactoryWithoutNamespace).value(XmlFileSource::parseXml).build();
    private static final String ROOT_TAG = "file";
    private static final String DATA_ATTR = "data";
    private static final String STRUCT_ATTR = "structure";

    public static Xml.Parser<FileSource> getParser() {
        return PARSER;
    }

    public static Xml.Formatter<FileSource> getFormatter() {
        return FORMATTER;
    }

    private static void formatXml(FileSource source, XMLStreamWriter xml, Charset encoding) throws XMLStreamException {
        xml.writeStartDocument(encoding.name(), "1.0");
        xml.writeEmptyElement(ROOT_TAG);
        xml.writeAttribute(DATA_ATTR, source.getData().toString());
        File structure = source.getStructure();
        if (XmlFileSource.isValidFile(structure)) {
            xml.writeAttribute(STRUCT_ATTR, source.getStructure().toString());
        }
        xml.writeEndDocument();
    }

    private static FileSource parseXml(XMLStreamReader xml) throws XMLStreamException {
        String data = null;
        String structure = null;
        while (xml.hasNext()) {
            if (xml.next() != 1 || !xml.getLocalName().equals(ROOT_TAG)) continue;
            data = xml.getAttributeValue(null, DATA_ATTR);
            structure = xml.getAttributeValue(null, STRUCT_ATTR);
        }
        if (XmlFileSource.isNullOrEmpty(data)) {
            throw new XMLStreamException("Missing data attribute");
        }
        return FileSource.builder().data(Paths.get(data, new String[0]).toFile()).structure(!XmlFileSource.isNullOrEmpty(structure) ? Paths.get(structure, new String[0]).toFile() : null).build();
    }

    public static boolean isValidFile(File file) {
        return file != null && !file.toString().isEmpty();
    }

    private static boolean isNullOrEmpty(String o) {
        return o == null || o.isEmpty();
    }

    @Generated
    private XmlFileSource() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

