/*
 * Decompiled with CFR 0.152.
 */
package internal.sdmxdl.format.xml;

import java.io.Closeable;
import java.io.IOException;
import java.util.Locale;
import java.util.function.Supplier;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import lombok.Generated;
import lombok.NonNull;
import nbbrd.io.Resource;
import nbbrd.io.WrappedIOException;

public final class XMLStreamUtil {
    static void closeBoth(XMLStreamReader reader, Closeable onClose) throws IOException {
        try {
            reader.close();
        }
        catch (XMLStreamException ex) {
            Resource.ensureClosed((Throwable)ex, (Closeable)onClose);
            throw WrappedIOException.wrap((Throwable)ex);
        }
        onClose.close();
    }

    public static boolean isNotNamespaceAware(@NonNull XMLStreamReader f) {
        if (f == null) {
            throw new NullPointerException("f is marked non-null but is null");
        }
        return (Boolean)f.getProperty("javax.xml.stream.isNamespaceAware") == false;
    }

    static boolean nextWhile(XMLStreamReader reader, TagVisitor func) throws XMLStreamException {
        while (reader.hasNext()) {
            int event = reader.next();
            if (event == 1) {
                switch (func.visitTag(true, reader.getLocalName()).ordinal()) {
                    case 1: {
                        break;
                    }
                    case 0: {
                        return false;
                    }
                    case 2: {
                        return true;
                    }
                }
                continue;
            }
            if (event != 2) continue;
            switch (func.visitTag(false, reader.getLocalName()).ordinal()) {
                case 1: {
                    break;
                }
                case 0: {
                    return false;
                }
                case 2: {
                    return true;
                }
            }
        }
        return false;
    }

    static boolean nextTags(XMLStreamReader reader, String tag) throws XMLStreamException {
        while (reader.hasNext()) {
            switch (reader.next()) {
                case 1: {
                    return true;
                }
                case 2: {
                    if (!XMLStreamUtil.isTagMatch(reader.getLocalName(), tag)) break;
                    return false;
                }
            }
        }
        return false;
    }

    static boolean nextTag(XMLStreamReader reader, String end, String start) throws XMLStreamException {
        while (reader.hasNext()) {
            switch (reader.next()) {
                case 1: {
                    if (!XMLStreamUtil.isTagMatch(reader.getLocalName(), start)) break;
                    return true;
                }
                case 2: {
                    if (!XMLStreamUtil.isTagMatch(reader.getLocalName(), end)) break;
                    return false;
                }
            }
        }
        return false;
    }

    static void check(boolean expression, XMLStreamReader reader, String message, Object ... args) throws XMLStreamException {
        XMLStreamUtil.check(expression, reader::getLocation, message, args);
    }

    static void check(boolean expression, Supplier<Location> location, String message, Object ... args) throws XMLStreamException {
        if (!expression) {
            throw new XMLStreamException(String.format(Locale.ROOT, message, args), location.get());
        }
    }

    static boolean isTagMatch(String localName, String tag) {
        return localName.endsWith(tag) && (localName.length() == tag.length() || localName.charAt(localName.length() - 1 - tag.length()) == ':');
    }

    @Generated
    private XMLStreamUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static interface TagVisitor {
        public Status visitTag(boolean var1, String var2) throws XMLStreamException;
    }

    static enum Status {
        HALT,
        CONTINUE,
        SUSPEND;

    }
}

