/*
 * Decompiled with CFR 0.152.
 */
package internal.sdmxdl.format.xml;

import internal.sdmxdl.format.xml.DsdContext;
import internal.sdmxdl.format.xml.Sdmxml;
import internal.sdmxdl.format.xml.TextBuilder;
import internal.sdmxdl.format.xml.XMLStreamUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import lombok.NonNull;
import sdmxdl.Attribute;
import sdmxdl.AttributeRelationship;
import sdmxdl.Codelist;
import sdmxdl.CodelistRef;
import sdmxdl.Component;
import sdmxdl.Dimension;
import sdmxdl.Languages;
import sdmxdl.Structure;
import sdmxdl.StructureRef;

public final class XMLStreamStructure21 {
    private static final String HEADER_TAG = "Header";
    private static final String STRUCTURES_TAG = "Structures";
    private static final String CODELISTS_TAG = "Codelists";
    private static final String CONCEPTS_TAG = "Concepts";
    private static final String DATA_STUCTURES_TAG = "DataStructures";
    private static final String CODELIST_TAG = "Codelist";
    private static final String CONCEPT_TAG = "Concept";
    private static final String CODE_TAG = "Code";
    private static final String DATA_STUCTURE_TAG = "DataStructure";
    private static final String DATA_STUCTURE_COMPONENTS_TAG = "DataStructureComponents";
    private static final String DIMENSION_LIST_TAG = "DimensionList";
    private static final String MEASURE_LIST_TAG = "MeasureList";
    private static final String DIMENSION_TAG = "Dimension";
    private static final String TIME_DIMENSION_TAG = "TimeDimension";
    private static final String PRIMARY_MEASURE_TAG = "PrimaryMeasure";
    private static final String NAME_TAG = "Name";
    private static final String LOCAL_REPRESENTATION_TAG = "LocalRepresentation";
    private static final String CONCEPT_IDENTITY_TAG = "ConceptIdentity";
    private static final String REF_TAG = "Ref";
    private static final String ATTRIBUTE_LIST_TAG = "AttributeList";
    private static final String ATTRIBUTE_TAG = "Attribute";
    private static final String ATTRIBUTE_RELATIONSHIP_TAG = "AttributeRelationship";
    private static final String ID_ATTR = "id";
    private static final String AGENCY_ID_ATTR = "agencyID";
    private static final String VERSION_ATTR = "version";
    private static final String LANG_ATTR = "lang";
    private static final String POSITION_ATTR = "position";
    private final TextBuilder structureLabel;
    private final TextBuilder label;

    public XMLStreamStructure21(Languages languages) {
        this.structureLabel = new TextBuilder(languages);
        this.label = new TextBuilder(languages);
    }

    @NonNull
    public List<Structure> parse(@NonNull XMLStreamReader reader) throws XMLStreamException {
        if (reader == null) {
            throw new NullPointerException("reader is marked non-null but is null");
        }
        if (XMLStreamUtil.isNotNamespaceAware(reader)) {
            throw new XMLStreamException("Cannot parse structure");
        }
        ArrayList<Structure> result = new ArrayList<Structure>();
        while (XMLStreamUtil.nextTags(reader, "")) {
            switch (reader.getLocalName()) {
                case "Header": {
                    this.parseHeader(reader);
                    break;
                }
                case "Structures": {
                    this.parseStructures(reader, result);
                }
            }
        }
        return result;
    }

    private void parseHeader(XMLStreamReader reader) throws XMLStreamException {
        String ns = reader.getNamespaceURI();
        XMLStreamUtil.check(Sdmxml.MESSAGE_V21.is(ns), reader, "Invalid namespace '%s'", ns);
    }

    private void parseStructures(XMLStreamReader reader, List<Structure> structs) throws XMLStreamException {
        DsdContext context = new DsdContext();
        while (XMLStreamUtil.nextTags(reader, STRUCTURES_TAG)) {
            switch (reader.getLocalName()) {
                case "Codelists": {
                    this.parseCodelists(reader, context.getCodelists());
                    break;
                }
                case "Concepts": {
                    this.parseConcepts(reader, context.getConcepts());
                    break;
                }
                case "DataStructures": {
                    this.parseDataStructures(reader, structs, context);
                }
            }
        }
    }

    private void parseCodelists(XMLStreamReader reader, List<Codelist> codelists) throws XMLStreamException {
        while (XMLStreamUtil.nextTag(reader, CODELISTS_TAG, CODELIST_TAG)) {
            this.parseCodelist(reader, codelists);
        }
    }

    private void parseCodelist(XMLStreamReader reader, List<Codelist> codelists) throws XMLStreamException {
        String id = reader.getAttributeValue(null, ID_ATTR);
        String version = reader.getAttributeValue(null, VERSION_ATTR);
        String agencyID = reader.getAttributeValue(null, AGENCY_ID_ATTR);
        XMLStreamUtil.check(id != null, reader, "Missing Codelist id", new Object[0]);
        CodelistRef ref = CodelistRef.of((String)agencyID, (String)id, (String)version);
        Codelist.Builder codelist = Codelist.builder().ref(ref);
        while (XMLStreamUtil.nextTag(reader, CODELIST_TAG, CODE_TAG)) {
            this.parseCode(reader, codelist);
        }
        codelists.add(codelist.build());
    }

    private void parseCode(XMLStreamReader reader, Codelist.Builder codelist) throws XMLStreamException {
        String id = reader.getAttributeValue(null, ID_ATTR);
        XMLStreamUtil.check(id != null, reader, "Missing Code id", new Object[0]);
        this.label.clear();
        while (XMLStreamUtil.nextTag(reader, CODE_TAG, NAME_TAG)) {
            this.parseNameTag(reader, this.label);
        }
        codelist.code(id, this.label.build(id));
    }

    private void parseConcepts(XMLStreamReader reader, Map<String, String> concepts) throws XMLStreamException {
        while (XMLStreamUtil.nextTag(reader, CONCEPTS_TAG, CONCEPT_TAG)) {
            this.parseConcept(reader, concepts);
        }
    }

    private void parseConcept(XMLStreamReader reader, Map<String, String> concepts) throws XMLStreamException {
        String id = reader.getAttributeValue(null, ID_ATTR);
        XMLStreamUtil.check(id != null, reader, "Missing Concept id", new Object[0]);
        this.label.clear();
        while (XMLStreamUtil.nextTag(reader, CONCEPT_TAG, NAME_TAG)) {
            this.parseNameTag(reader, this.label);
        }
        concepts.put(id, this.label.build(id));
    }

    private void parseDataStructures(XMLStreamReader reader, List<Structure> result, DsdContext context) throws XMLStreamException {
        while (XMLStreamUtil.nextTag(reader, DATA_STUCTURES_TAG, DATA_STUCTURE_TAG)) {
            this.parseDataStructure(reader, result, context);
        }
    }

    private void parseDataStructure(XMLStreamReader reader, List<Structure> result, DsdContext context) throws XMLStreamException {
        String id = reader.getAttributeValue(null, ID_ATTR);
        XMLStreamUtil.check(id != null, reader, "Missing DataStrucure id", new Object[0]);
        Structure.Builder ds = Structure.builder();
        ds.ref(StructureRef.of((String)reader.getAttributeValue(null, AGENCY_ID_ATTR), (String)id, (String)reader.getAttributeValue(null, VERSION_ATTR)));
        this.structureLabel.clear();
        while (XMLStreamUtil.nextTags(reader, DATA_STUCTURE_TAG)) {
            switch (reader.getLocalName()) {
                case "Name": {
                    this.parseNameTag(reader, this.structureLabel);
                    break;
                }
                case "DataStructureComponents": {
                    this.parseDataStructureComponents(reader, ds, context);
                }
            }
        }
        ds.name(this.structureLabel.build(id));
        result.add(ds.build());
    }

    private void parseDataStructureComponents(XMLStreamReader reader, Structure.Builder ds, DsdContext context) throws XMLStreamException {
        while (XMLStreamUtil.nextTags(reader, DATA_STUCTURE_COMPONENTS_TAG)) {
            switch (reader.getLocalName()) {
                case "DimensionList": {
                    this.parseDimensionList(reader, ds, context);
                    break;
                }
                case "MeasureList": {
                    this.parseMeasureList(reader, ds);
                    break;
                }
                case "AttributeList": {
                    this.parseAttributeList(reader, ds, context);
                }
            }
        }
    }

    private void parseDimensionList(XMLStreamReader reader, Structure.Builder ds, DsdContext context) throws XMLStreamException {
        while (XMLStreamUtil.nextTags(reader, DIMENSION_LIST_TAG)) {
            switch (reader.getLocalName()) {
                case "Dimension": {
                    this.parseDimension(reader, ds, context);
                    break;
                }
                case "TimeDimension": {
                    this.parseTimeDimension(reader, ds);
                }
            }
        }
    }

    private void parseDimension(XMLStreamReader reader, Structure.Builder ds, DsdContext context) throws XMLStreamException {
        String id = reader.getAttributeValue(null, ID_ATTR);
        XMLStreamUtil.check(id != null, reader, "Missing Dimension id", new Object[0]);
        String position = reader.getAttributeValue(null, POSITION_ATTR);
        XMLStreamUtil.check(position != null, reader, "Missing Dimension position", new Object[0]);
        Dimension.Builder dimension = Dimension.builder().id(id).position(this.parseInt(position)).name(id);
        while (XMLStreamUtil.nextTags(reader, DIMENSION_TAG)) {
            switch (reader.getLocalName()) {
                case "ConceptIdentity": {
                    this.parseConceptIdentity(reader, (Component.Builder<?>)dimension, context);
                    break;
                }
                case "LocalRepresentation": {
                    this.parseLocalRepresentation(reader, (Component.Builder<?>)dimension, context);
                }
            }
        }
        ds.dimension(dimension.build());
        context.incrementDimensionCount();
    }

    private void parseConceptIdentity(XMLStreamReader reader, Component.Builder<?> concept, DsdContext context) throws XMLStreamException {
        if (XMLStreamUtil.nextTag(reader, CONCEPT_IDENTITY_TAG, REF_TAG)) {
            String id = reader.getAttributeValue(null, ID_ATTR);
            XMLStreamUtil.check(id != null, reader, "Missing Ref id", new Object[0]);
            String conceptName = context.getConcepts().get(id);
            concept.name(conceptName != null ? conceptName : id);
        }
    }

    private void parseLocalRepresentation(XMLStreamReader reader, Component.Builder<?> component, DsdContext context) throws XMLStreamException {
        if (XMLStreamUtil.nextTag(reader, LOCAL_REPRESENTATION_TAG, REF_TAG)) {
            String id = reader.getAttributeValue(null, ID_ATTR);
            String version = reader.getAttributeValue(null, VERSION_ATTR);
            String agencyID = reader.getAttributeValue(null, AGENCY_ID_ATTR);
            XMLStreamUtil.check(id != null, reader, "Missing Codelist id", new Object[0]);
            CodelistRef ref = CodelistRef.of((String)agencyID, (String)id, (String)version);
            component.codelist(context.getCodelist(ref));
        }
    }

    private void parseTimeDimension(XMLStreamReader reader, Structure.Builder ds) throws XMLStreamException {
        String id = reader.getAttributeValue(null, ID_ATTR);
        XMLStreamUtil.check(id != null, reader, "Missing TimeDimension id", new Object[0]);
        ds.timeDimensionId(id);
    }

    private void parseMeasureList(XMLStreamReader reader, Structure.Builder ds) throws XMLStreamException {
        if (XMLStreamUtil.nextTag(reader, MEASURE_LIST_TAG, PRIMARY_MEASURE_TAG)) {
            String id = reader.getAttributeValue(null, ID_ATTR);
            XMLStreamUtil.check(id != null, reader, "Missing PrimaryMeasure id", new Object[0]);
            ds.primaryMeasureId(id);
        }
    }

    private void parseNameTag(XMLStreamReader reader, TextBuilder langStack) throws XMLStreamException {
        String lang = reader.getAttributeValue(null, LANG_ATTR);
        if (lang != null) {
            langStack.put(lang, reader.getElementText());
        }
    }

    private void parseAttributeList(XMLStreamReader reader, Structure.Builder ds, DsdContext context) throws XMLStreamException {
        while (XMLStreamUtil.nextTags(reader, ATTRIBUTE_LIST_TAG)) {
            switch (reader.getLocalName()) {
                case "Attribute": {
                    this.parseAttribute(reader, ds, context);
                }
            }
        }
    }

    private void parseAttribute(XMLStreamReader reader, Structure.Builder ds, DsdContext context) throws XMLStreamException {
        String id = reader.getAttributeValue(null, ID_ATTR);
        XMLStreamUtil.check(id != null, reader, "Missing Attribute id", new Object[0]);
        Attribute.Builder attribute = Attribute.builder().id(id).name(id);
        while (XMLStreamUtil.nextTags(reader, ATTRIBUTE_TAG)) {
            switch (reader.getLocalName()) {
                case "ConceptIdentity": {
                    this.parseConceptIdentity(reader, (Component.Builder<?>)attribute, context);
                    break;
                }
                case "LocalRepresentation": {
                    this.parseLocalRepresentation(reader, (Component.Builder<?>)attribute, context);
                    break;
                }
                case "AttributeRelationship": {
                    this.parseAttributeRelationship(reader, attribute, context);
                }
            }
        }
        ds.attribute(attribute.build());
    }

    private void parseAttributeRelationship(XMLStreamReader reader, Attribute.Builder attribute, DsdContext context) throws XMLStreamException {
        attribute.relationship(AttributeRelationship.DATAFLOW);
        int dimensionCount = 0;
        while (XMLStreamUtil.nextTags(reader, ATTRIBUTE_RELATIONSHIP_TAG)) {
            switch (reader.getLocalName()) {
                case "PrimaryMeasure": {
                    attribute.relationship(AttributeRelationship.OBSERVATION);
                    break;
                }
                case "Dimension": {
                    ++dimensionCount;
                }
            }
        }
        if (dimensionCount > 0) {
            attribute.relationship(dimensionCount < context.getDimensionCount() ? AttributeRelationship.GROUP : AttributeRelationship.SERIES);
        }
    }

    private int parseInt(String value) throws XMLStreamException {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException ex) {
            throw new XMLStreamException(ex);
        }
    }
}

