/*
 * Decompiled with CFR 0.152.
 */
package internal.sdmxdl.format.xml;

import internal.sdmxdl.format.xml.DsdContext;
import internal.sdmxdl.format.xml.Sdmxml;
import internal.sdmxdl.format.xml.TextBuilder;
import internal.sdmxdl.format.xml.XMLStreamUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import lombok.NonNull;
import sdmxdl.Attribute;
import sdmxdl.AttributeRelationship;
import sdmxdl.Codelist;
import sdmxdl.CodelistRef;
import sdmxdl.Component;
import sdmxdl.Dimension;
import sdmxdl.Languages;
import sdmxdl.Structure;
import sdmxdl.StructureRef;

public final class XMLStreamStructure20 {
    private static final String HEADER_TAG = "Header";
    private static final String CODE_LISTS_TAG = "CodeLists";
    private static final String CONCEPTS_TAG = "Concepts";
    private static final String KEY_FAMILIES_TAG = "KeyFamilies";
    private static final String CODE_LIST_TAG = "CodeList";
    private static final String CONCEPT_TAG = "Concept";
    private static final String KEY_FAMILY_TAG = "KeyFamily";
    private static final String CODE_TAG = "Code";
    private static final String DESCRIPTION_TAG = "Description";
    private static final String NAME_TAG = "Name";
    private static final String COMPONENTS_TAG = "Components";
    private static final String DIMENSION_TAG = "Dimension";
    private static final String TIME_DIMENSION_TAG = "TimeDimension";
    private static final String PRIMARY_MEASURE_TAG = "PrimaryMeasure";
    private static final String ATTRIBUTE_TAG = "Attribute";
    private static final String ID_ATTR = "id";
    private static final String AGENCY_ID_ATTR = "agencyID";
    private static final String VERSION_ATTR = "version";
    private static final String LANG_ATTR = "lang";
    private static final String VALUE_ATTR = "value";
    private static final String CONCEPT_REF_ATTR = "conceptRef";
    private static final String CODELIST_ATTR = "codelist";
    private static final String ATTACHMENT_LEVEL_ATTR = "attachmentLevel";
    private final TextBuilder structureLabel;
    private final TextBuilder label;

    public XMLStreamStructure20(Languages languages) {
        this.structureLabel = new TextBuilder(languages);
        this.label = new TextBuilder(languages);
    }

    @NonNull
    public List<Structure> parse(@NonNull XMLStreamReader reader) throws XMLStreamException {
        if (reader == null) {
            throw new NullPointerException("reader is marked non-null but is null");
        }
        if (XMLStreamUtil.isNotNamespaceAware(reader)) {
            throw new XMLStreamException("Cannot parse structure");
        }
        ArrayList<Structure> result = new ArrayList<Structure>();
        DsdContext context = new DsdContext();
        while (XMLStreamUtil.nextTags(reader, "")) {
            switch (reader.getLocalName()) {
                case "Header": {
                    this.parseHeader(reader);
                    break;
                }
                case "CodeLists": {
                    this.parseCodelists(reader, context.getCodelists());
                    break;
                }
                case "Concepts": {
                    this.parseConcepts(reader, context.getConcepts());
                    break;
                }
                case "KeyFamilies": {
                    this.parseDataStructures(reader, result, context);
                }
            }
        }
        return result;
    }

    private void parseHeader(XMLStreamReader reader) throws XMLStreamException {
        String ns = reader.getNamespaceURI();
        XMLStreamUtil.check(Sdmxml.MESSAGE_V20.is(ns), reader, "Invalid namespace '%s'", ns);
    }

    private void parseCodelists(XMLStreamReader reader, List<Codelist> codelists) throws XMLStreamException {
        while (XMLStreamUtil.nextTag(reader, CODE_LISTS_TAG, CODE_LIST_TAG)) {
            this.parseCodelist(reader, codelists);
        }
    }

    private void parseCodelist(XMLStreamReader reader, List<Codelist> codelists) throws XMLStreamException {
        String id = reader.getAttributeValue(null, ID_ATTR);
        String version = reader.getAttributeValue(null, VERSION_ATTR);
        String agencyID = reader.getAttributeValue(null, AGENCY_ID_ATTR);
        XMLStreamUtil.check(id != null, reader, "Missing Codelist id", new Object[0]);
        CodelistRef ref = CodelistRef.of((String)agencyID, (String)id, (String)version);
        Codelist.Builder codelist = Codelist.builder().ref(ref);
        while (XMLStreamUtil.nextTag(reader, CODE_LIST_TAG, CODE_TAG)) {
            this.parseCode(reader, codelist);
        }
        codelists.add(codelist.build());
    }

    private void parseCode(XMLStreamReader reader, Codelist.Builder codelist) throws XMLStreamException {
        String id = reader.getAttributeValue(null, VALUE_ATTR);
        XMLStreamUtil.check(id != null, reader, "Missing Code value", new Object[0]);
        this.label.clear();
        while (XMLStreamUtil.nextTag(reader, CODE_TAG, DESCRIPTION_TAG)) {
            this.parseNameTag(reader, this.label);
        }
        codelist.code(id, this.label.build(id));
    }

    private void parseConcepts(XMLStreamReader reader, Map<String, String> concepts) throws XMLStreamException {
        while (XMLStreamUtil.nextTag(reader, CONCEPTS_TAG, CONCEPT_TAG)) {
            this.parseConcept(reader, concepts);
        }
    }

    private void parseConcept(XMLStreamReader reader, Map<String, String> concepts) throws XMLStreamException {
        String id = reader.getAttributeValue(null, ID_ATTR);
        XMLStreamUtil.check(id != null, reader, "Missing Concept id", new Object[0]);
        this.label.clear();
        while (XMLStreamUtil.nextTag(reader, CONCEPT_TAG, NAME_TAG)) {
            this.parseNameTag(reader, this.label);
        }
        concepts.put(id, this.label.build(id));
    }

    private void parseDataStructures(XMLStreamReader reader, List<Structure> result, DsdContext context) throws XMLStreamException {
        while (XMLStreamUtil.nextTag(reader, KEY_FAMILIES_TAG, KEY_FAMILY_TAG)) {
            this.parseDataStructure(reader, result, context);
        }
    }

    private void parseDataStructure(XMLStreamReader reader, List<Structure> result, DsdContext context) throws XMLStreamException {
        String id = reader.getAttributeValue(null, ID_ATTR);
        XMLStreamUtil.check(id != null, reader, "Missing DataStrucure id", new Object[0]);
        String optionalAgency = reader.getAttributeValue(null, AGENCY_ID_ATTR);
        String optionalVersion = reader.getAttributeValue(null, VERSION_ATTR);
        Structure.Builder ds = Structure.builder().ref(StructureRef.of((String)optionalAgency, (String)id, (String)optionalVersion)).primaryMeasureId("");
        this.structureLabel.clear();
        while (XMLStreamUtil.nextTags(reader, KEY_FAMILY_TAG)) {
            switch (reader.getLocalName()) {
                case "Name": {
                    this.parseNameTag(reader, this.structureLabel);
                    break;
                }
                case "Components": {
                    this.parseDataStructureComponents(reader, ds, context);
                }
            }
        }
        ds.name(this.structureLabel.build(id));
        result.add(ds.build());
    }

    private void parseDataStructureComponents(XMLStreamReader reader, Structure.Builder ds, DsdContext context) throws XMLStreamException {
        int position = 1;
        while (XMLStreamUtil.nextTags(reader, COMPONENTS_TAG)) {
            switch (reader.getLocalName()) {
                case "Dimension": {
                    this.parseDimension(reader, ds, context, position++);
                    break;
                }
                case "TimeDimension": {
                    this.parseTimeDimension(reader, ds);
                    break;
                }
                case "PrimaryMeasure": {
                    this.parsePrimaryMeasure(reader, ds);
                    break;
                }
                case "Attribute": {
                    this.parseAttribute(reader, ds, context);
                }
            }
        }
    }

    private void parseComponent(XMLStreamReader reader, Component.Builder<?> component, DsdContext context) throws XMLStreamException {
        String id = reader.getAttributeValue(null, CONCEPT_REF_ATTR);
        XMLStreamUtil.check(id != null, reader, "Missing Dimension id", new Object[0]);
        String codelist = reader.getAttributeValue(null, CODELIST_ATTR);
        XMLStreamUtil.check(codelist != null, reader, "Missing Dimension codelist", new Object[0]);
        component.id(id);
        String conceptName = context.getConcepts().get(id);
        component.name(conceptName != null ? conceptName : id);
        CodelistRef ref = CodelistRef.of(null, (String)codelist, null);
        component.codelist(context.getCodelist(ref));
    }

    private void parseDimension(XMLStreamReader reader, Structure.Builder ds, DsdContext context, int position) throws XMLStreamException {
        Dimension.Builder result = Dimension.builder();
        this.parseComponent(reader, (Component.Builder<?>)result, context);
        ds.dimension(result.position(position).build());
    }

    private void parseTimeDimension(XMLStreamReader reader, Structure.Builder ds) throws XMLStreamException {
        String id = reader.getAttributeValue(null, CONCEPT_REF_ATTR);
        XMLStreamUtil.check(id != null, reader, "Missing TimeDimension id", new Object[0]);
        ds.timeDimensionId(id);
    }

    private void parsePrimaryMeasure(XMLStreamReader reader, Structure.Builder ds) throws XMLStreamException {
        String id = reader.getAttributeValue(null, CONCEPT_REF_ATTR);
        XMLStreamUtil.check(id != null, reader, "Missing PrimaryMeasure id", new Object[0]);
        ds.primaryMeasureId(id);
    }

    private void parseNameTag(XMLStreamReader reader, TextBuilder langStack) throws XMLStreamException {
        String lang = reader.getAttributeValue(null, LANG_ATTR);
        if (lang != null) {
            langStack.put(lang, reader.getElementText());
        }
    }

    private void parseAttribute(XMLStreamReader reader, Structure.Builder ds, DsdContext context) throws XMLStreamException {
        Attribute.Builder result = Attribute.builder();
        this.parseComponent(reader, (Component.Builder<?>)result, context);
        result.relationship(this.getAttributeRelationship(reader.getAttributeValue(null, ATTACHMENT_LEVEL_ATTR)));
        ds.attribute(result.build());
    }

    private AttributeRelationship getAttributeRelationship(String attachmentLevel) {
        if (attachmentLevel != null) {
            switch (attachmentLevel) {
                case "DataSet": {
                    return AttributeRelationship.DATAFLOW;
                }
                case "Group": {
                    return AttributeRelationship.GROUP;
                }
                case "Series": {
                    return AttributeRelationship.SERIES;
                }
                case "Observation": {
                    return AttributeRelationship.OBSERVATION;
                }
            }
        }
        return AttributeRelationship.UNKNOWN;
    }
}

