/*
 * Decompiled with CFR 0.152.
 */
package internal.sdmxdl.format.xml;

import internal.sdmxdl.format.xml.Sdmxml;
import internal.sdmxdl.format.xml.TextBuilder;
import internal.sdmxdl.format.xml.XMLStreamUtil;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import lombok.NonNull;
import nbbrd.io.text.Parser;
import sdmxdl.Languages;
import sdmxdl.format.MessageFooter;

public final class XMLStreamMessageFooter21 {
    private static final String HEADER_TAG = "Header";
    private static final String FOOTER_TAG = "Footer";
    private static final String MESSAGE_TAG = "Message";
    private static final String TEXT_TAG = "Text";
    private static final String CODE_ATTR = "code";
    private static final String SEVERITY_ATTR = "severity";
    private static final String LANG_ATTR = "lang";
    private final TextBuilder label;

    public XMLStreamMessageFooter21(Languages langs) {
        this.label = new TextBuilder(langs);
    }

    @NonNull
    public MessageFooter parse(@NonNull XMLStreamReader reader) throws XMLStreamException {
        if (reader == null) {
            throw new NullPointerException("reader is marked non-null but is null");
        }
        if (XMLStreamUtil.isNotNamespaceAware(reader)) {
            throw new XMLStreamException("Cannot parse structure");
        }
        MessageFooter.Builder result = MessageFooter.builder();
        while (XMLStreamUtil.nextTags(reader, "")) {
            switch (reader.getLocalName()) {
                case "Header": {
                    this.parseHeader(reader);
                    break;
                }
                case "Footer": {
                    while (XMLStreamUtil.nextTag(reader, FOOTER_TAG, MESSAGE_TAG)) {
                        this.parseMessage(reader, result);
                    }
                    break;
                }
            }
        }
        return result.build();
    }

    private void parseHeader(XMLStreamReader reader) throws XMLStreamException {
        String ns = reader.getNamespaceURI();
        XMLStreamUtil.check(Sdmxml.MESSAGE_V21.is(ns), reader, "Invalid namespace '%s'", ns);
    }

    private void parseMessage(XMLStreamReader reader, MessageFooter.Builder result) throws XMLStreamException {
        String code = reader.getAttributeValue(null, CODE_ATTR);
        XMLStreamUtil.check(code != null, reader, "Missing code", new Object[0]);
        result.code(((Integer)Parser.onInteger().parseValue((CharSequence)code).orElseThrow(() -> new XMLStreamException("Cannot parse fotter code"))).intValue());
        result.severity(reader.getAttributeValue(null, SEVERITY_ATTR));
        while (XMLStreamUtil.nextTag(reader, MESSAGE_TAG, TEXT_TAG)) {
            this.parseText(reader, result);
        }
    }

    private void parseText(XMLStreamReader reader, MessageFooter.Builder result) throws XMLStreamException {
        this.label.clear();
        String lang = reader.getAttributeValue(null, LANG_ATTR);
        if (lang != null) {
            this.label.put(lang, reader.getElementText());
        }
        result.text(this.label.build());
    }
}

