/*
 * Decompiled with CFR 0.152.
 */
package internal.sdmxdl.format.xml;

import internal.sdmxdl.format.xml.AttributesBuilder;
import internal.sdmxdl.format.xml.XMLStreamUtil;
import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import lombok.NonNull;
import nbbrd.io.WrappedIOException;
import org.checkerframework.checker.nullness.qual.Nullable;
import sdmxdl.Key;
import sdmxdl.format.DataCursor;
import sdmxdl.format.ObsParser;
import sdmxdl.format.time.ObservationalTimePeriod;

public final class XMLStreamGenericDataCursor
implements DataCursor {
    private static final String DATASET_TAG = "DataSet";
    private static final String SERIES_TAG = "Series";
    private static final String OBS_TAG = "Obs";
    private static final String OBS_VALUE_TAG = "ObsValue";
    private static final String SERIES_KEY_TAG = "SeriesKey";
    private static final String ATTRIBUTES_TAG = "Attributes";
    private static final String VALUE_TAG = "Value";
    private static final String VALUE_ATTR = "value";
    private final XMLStreamReader reader;
    private final Closeable onClose;
    private final Key.Builder keyBuilder;
    private final AttributesBuilder seriesAttributes;
    private final ObsParser obsParser;
    private final AttributesBuilder obsAttributes;
    private final SeriesHeadParser headParser;
    private boolean closed;
    private boolean hasSeries;
    private boolean hasObs;

    public static XMLStreamGenericDataCursor sdmx20(XMLStreamReader reader, Closeable onClose, Key.Builder keyBuilder, ObsParser obsParser) {
        return new XMLStreamGenericDataCursor(reader, onClose, keyBuilder, obsParser, SeriesHeadParser.SDMX20);
    }

    public static XMLStreamGenericDataCursor sdmx21(XMLStreamReader reader, Closeable onClose, Key.Builder keyBuilder, ObsParser obsParser) {
        return new XMLStreamGenericDataCursor(reader, onClose, keyBuilder, obsParser, SeriesHeadParser.SDMX21);
    }

    private XMLStreamGenericDataCursor(XMLStreamReader reader, Closeable onClose, Key.Builder keyBuilder, ObsParser obsParser, SeriesHeadParser headParser) {
        if (!XMLStreamUtil.isNotNamespaceAware(reader)) {
            throw new IllegalArgumentException("Using XMLStreamReader with namespace awareness");
        }
        this.reader = reader;
        this.onClose = onClose;
        this.keyBuilder = keyBuilder;
        this.seriesAttributes = new AttributesBuilder();
        this.obsParser = obsParser;
        this.obsAttributes = new AttributesBuilder();
        this.headParser = headParser;
        this.closed = false;
        this.hasSeries = false;
        this.hasObs = false;
    }

    public boolean nextSeries() throws IOException {
        this.checkState();
        this.keyBuilder.clear();
        this.seriesAttributes.clear();
        try {
            this.hasSeries = this.nextWhile(this::onDataSet);
            return this.hasSeries;
        }
        catch (XMLStreamException ex) {
            throw WrappedIOException.wrap((Throwable)ex);
        }
    }

    public boolean nextObs() throws IOException {
        this.checkSeriesState();
        this.obsParser.clear();
        this.obsAttributes.clear();
        try {
            if (this.isCurrentElementStartOfObs()) {
                this.parseObs();
                this.hasObs = true;
                return true;
            }
            if (this.isCurrentElementEnfOfSeries()) {
                this.hasObs = false;
                return false;
            }
            this.hasObs = this.nextWhile(this::onSeriesBody);
            return this.hasObs;
        }
        catch (XMLStreamException ex) {
            throw WrappedIOException.wrap((Throwable)ex);
        }
    }

    @NonNull
    public Key getSeriesKey() throws IOException {
        this.checkSeriesState();
        if (!this.keyBuilder.isSeries()) {
            throw new IOException("Invalid series key '" + this.keyBuilder + "'");
        }
        return this.keyBuilder.build();
    }

    public String getSeriesAttribute(@NonNull String key) throws IOException {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        this.checkSeriesState();
        return this.seriesAttributes.getAttribute(key);
    }

    @NonNull
    public Map<String, String> getSeriesAttributes() throws IOException {
        this.checkSeriesState();
        return this.seriesAttributes.build();
    }

    public ObservationalTimePeriod getObsPeriod() throws IOException {
        this.checkObsState();
        return this.obsParser.parsePeriod();
    }

    public Double getObsValue() throws IOException {
        this.checkObsState();
        return this.obsParser.parseValue();
    }

    @NonNull
    public Map<String, String> getObsAttributes() throws IOException {
        this.checkObsState();
        return this.obsAttributes.build();
    }

    public @Nullable String getObsAttribute(@NonNull String key) throws IOException, IllegalStateException {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        this.checkObsState();
        return this.obsAttributes.getAttribute(key);
    }

    public void close() throws IOException {
        this.closed = true;
        XMLStreamUtil.closeBoth(this.reader, this.onClose);
    }

    private void checkState() throws IOException {
        if (this.closed) {
            throw new IOException("Cursor closed");
        }
    }

    private void checkSeriesState() throws IOException, IllegalStateException {
        this.checkState();
        if (!this.hasSeries) {
            throw new IllegalStateException();
        }
    }

    private void checkObsState() throws IOException, IllegalStateException {
        this.checkSeriesState();
        if (!this.hasObs) {
            throw new IllegalStateException();
        }
    }

    private XMLStreamUtil.Status onDataSet(boolean start, String localName) throws XMLStreamException {
        if (start) {
            return XMLStreamUtil.isTagMatch(localName, SERIES_TAG) ? this.parseSeries() : XMLStreamUtil.Status.CONTINUE;
        }
        return XMLStreamUtil.isTagMatch(localName, DATASET_TAG) ? XMLStreamUtil.Status.HALT : XMLStreamUtil.Status.CONTINUE;
    }

    private XMLStreamUtil.Status parseSeries() throws XMLStreamException {
        this.nextWhile(this::onSeriesHead);
        return XMLStreamUtil.Status.SUSPEND;
    }

    private XMLStreamUtil.Status onSeriesHead(boolean start, String localName) throws XMLStreamException {
        if (start) {
            if (XMLStreamUtil.isTagMatch(localName, SERIES_KEY_TAG)) {
                return this.parseSeriesKey();
            }
            if (XMLStreamUtil.isTagMatch(localName, ATTRIBUTES_TAG)) {
                return this.parseAttributes(this.seriesAttributes);
            }
            if (XMLStreamUtil.isTagMatch(localName, OBS_TAG)) {
                return XMLStreamUtil.Status.HALT;
            }
            return XMLStreamUtil.Status.CONTINUE;
        }
        return XMLStreamUtil.isTagMatch(localName, SERIES_TAG) ? XMLStreamUtil.Status.HALT : XMLStreamUtil.Status.CONTINUE;
    }

    private XMLStreamUtil.Status parseSeriesKey() throws XMLStreamException {
        this.nextWhile(this::onSeriesKey);
        return XMLStreamUtil.Status.CONTINUE;
    }

    private XMLStreamUtil.Status parseAttributes(AttributesBuilder builder) throws XMLStreamException {
        this.nextWhile((start, localName) -> this.onAttributes(start, localName, builder));
        return XMLStreamUtil.Status.CONTINUE;
    }

    private XMLStreamUtil.Status onSeriesKey(boolean start, String localName) throws XMLStreamException {
        if (start) {
            return XMLStreamUtil.isTagMatch(localName, VALUE_TAG) ? this.parseSeriesKeyValue() : XMLStreamUtil.Status.CONTINUE;
        }
        return XMLStreamUtil.isTagMatch(localName, SERIES_KEY_TAG) ? XMLStreamUtil.Status.HALT : XMLStreamUtil.Status.CONTINUE;
    }

    private XMLStreamUtil.Status onAttributes(boolean start, String localName, AttributesBuilder builder) throws XMLStreamException {
        if (start) {
            return XMLStreamUtil.isTagMatch(localName, VALUE_TAG) ? this.parseAttributesValue(builder) : XMLStreamUtil.Status.CONTINUE;
        }
        return XMLStreamUtil.isTagMatch(localName, ATTRIBUTES_TAG) ? XMLStreamUtil.Status.HALT : XMLStreamUtil.Status.CONTINUE;
    }

    private XMLStreamUtil.Status parseSeriesKeyValue() throws XMLStreamException {
        this.headParser.parseValueElement(this.reader, (arg_0, arg_1) -> ((Key.Builder)this.keyBuilder).put(arg_0, arg_1));
        return XMLStreamUtil.Status.CONTINUE;
    }

    private XMLStreamUtil.Status parseAttributesValue(AttributesBuilder builder) throws XMLStreamException {
        this.headParser.parseValueElement(this.reader, builder::put);
        return XMLStreamUtil.Status.CONTINUE;
    }

    private boolean isCurrentElementStartOfObs() {
        return this.reader.isStartElement() && XMLStreamUtil.isTagMatch(this.reader.getLocalName(), OBS_TAG);
    }

    private boolean isCurrentElementEnfOfSeries() {
        return this.reader.isEndElement() && XMLStreamUtil.isTagMatch(this.reader.getLocalName(), SERIES_TAG);
    }

    private XMLStreamUtil.Status onSeriesBody(boolean start, String localName) throws XMLStreamException {
        if (start) {
            return XMLStreamUtil.isTagMatch(localName, OBS_TAG) ? this.parseObs() : XMLStreamUtil.Status.CONTINUE;
        }
        return XMLStreamUtil.isTagMatch(localName, SERIES_TAG) ? XMLStreamUtil.Status.HALT : XMLStreamUtil.Status.CONTINUE;
    }

    private XMLStreamUtil.Status onObs(boolean start, String localName) throws XMLStreamException {
        if (start) {
            if (XMLStreamUtil.isTagMatch(localName, this.headParser.getTimeELement())) {
                return this.parseObsTime();
            }
            if (XMLStreamUtil.isTagMatch(localName, ATTRIBUTES_TAG)) {
                return this.parseAttributes(this.obsAttributes);
            }
            if (XMLStreamUtil.isTagMatch(localName, OBS_VALUE_TAG)) {
                return this.parseObsValue();
            }
            return XMLStreamUtil.Status.CONTINUE;
        }
        return XMLStreamUtil.isTagMatch(localName, OBS_TAG) ? XMLStreamUtil.Status.HALT : XMLStreamUtil.Status.CONTINUE;
    }

    private XMLStreamUtil.Status parseObs() throws XMLStreamException {
        this.nextWhile(this::onObs);
        return XMLStreamUtil.Status.SUSPEND;
    }

    private XMLStreamUtil.Status parseObsTime() throws XMLStreamException {
        this.headParser.parseTimeElement(this.reader, arg_0 -> ((ObsParser)this.obsParser).period(arg_0));
        return XMLStreamUtil.Status.CONTINUE;
    }

    private XMLStreamUtil.Status parseObsValue() {
        this.obsParser.value(this.reader.getAttributeValue(null, VALUE_ATTR));
        return XMLStreamUtil.Status.CONTINUE;
    }

    private boolean nextWhile(XMLStreamUtil.TagVisitor func) throws XMLStreamException {
        return XMLStreamUtil.nextWhile(this.reader, func);
    }

    private static enum SeriesHeadParser {
        SDMX20{

            @Override
            public void parseValueElement(XMLStreamReader r, BiConsumer<String, String> c) {
                c.accept(r.getAttributeValue(null, "concept"), r.getAttributeValue(null, XMLStreamGenericDataCursor.VALUE_ATTR));
            }

            @Override
            public void parseTimeElement(XMLStreamReader r, Consumer<String> c) throws XMLStreamException {
                c.accept(r.getElementText());
            }

            @Override
            public String getTimeELement() {
                return "Time";
            }
        }
        ,
        SDMX21{

            @Override
            public void parseValueElement(XMLStreamReader r, BiConsumer<String, String> c) {
                c.accept(r.getAttributeValue(null, "id"), r.getAttributeValue(null, XMLStreamGenericDataCursor.VALUE_ATTR));
            }

            @Override
            public void parseTimeElement(XMLStreamReader r, Consumer<String> c) {
                c.accept(r.getAttributeValue(null, XMLStreamGenericDataCursor.VALUE_ATTR));
            }

            @Override
            public String getTimeELement() {
                return "ObsDimension";
            }
        };


        abstract void parseValueElement(@NonNull XMLStreamReader var1, @NonNull BiConsumer<String, String> var2) throws XMLStreamException;

        abstract void parseTimeElement(@NonNull XMLStreamReader var1, @NonNull Consumer<String> var2) throws XMLStreamException;

        @NonNull
        abstract String getTimeELement();
    }
}

