/*
 * Decompiled with CFR 0.152.
 */
package internal.sdmxdl.format.xml;

import internal.sdmxdl.format.xml.Sdmxml;
import internal.sdmxdl.format.xml.TextBuilder;
import internal.sdmxdl.format.xml.XMLStreamUtil;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import lombok.NonNull;
import sdmxdl.Flow;
import sdmxdl.FlowRef;
import sdmxdl.Languages;
import sdmxdl.StructureRef;

public final class XMLStreamFlow21 {
    private static final String HEADER_TAG = "Header";
    private static final String STRUCTURES_TAG = "Structures";
    private static final String DATAFLOWS_TAG = "Dataflows";
    private static final String DATAFLOW_TAG = "Dataflow";
    private static final String NAME_TAG = "Name";
    private static final String DESCRIPTION_TAG = "Description";
    private static final String STRUCTURE_TAG = "Structure";
    private static final String REF_TAG = "Ref";
    private static final String ID_ATTR = "id";
    private static final String AGENCY_ID_ATTR = "agencyID";
    private static final String VERSION_ATTR = "version";
    private static final String LANG_ATTR = "lang";
    private static final String IS_EXTERNAL_REFERENCE_ATTR = "isExternalReference";
    private final TextBuilder flowName;
    private final TextBuilder flowDescription;

    public XMLStreamFlow21(Languages languages) {
        this.flowName = new TextBuilder(languages);
        this.flowDescription = new TextBuilder(languages);
    }

    @NonNull
    public List<Flow> parse(@NonNull XMLStreamReader reader) throws XMLStreamException {
        if (reader == null) {
            throw new NullPointerException("reader is marked non-null but is null");
        }
        if (XMLStreamUtil.isNotNamespaceAware(reader)) {
            throw new XMLStreamException("Cannot parse flows");
        }
        ArrayList<Flow> result = new ArrayList<Flow>();
        while (XMLStreamUtil.nextTags(reader, "")) {
            switch (reader.getLocalName()) {
                case "Header": {
                    this.parseHeader(reader);
                    break;
                }
                case "Structures": {
                    this.parseStructures(reader, result);
                }
            }
        }
        return result;
    }

    private void parseHeader(XMLStreamReader reader) throws XMLStreamException {
        String ns = reader.getNamespaceURI();
        XMLStreamUtil.check(Sdmxml.MESSAGE_V21.is(ns), reader, "Invalid namespace '%s'", ns);
    }

    private void parseStructures(XMLStreamReader reader, List<Flow> flows) throws XMLStreamException {
        if (XMLStreamUtil.nextTag(reader, STRUCTURES_TAG, DATAFLOWS_TAG)) {
            this.parseDataflows(reader, flows);
        }
    }

    private void parseDataflows(XMLStreamReader reader, List<Flow> flows) throws XMLStreamException {
        while (XMLStreamUtil.nextTags(reader, DATAFLOWS_TAG)) {
            switch (reader.getLocalName()) {
                case "Dataflow": {
                    if (this.isExternalReference(reader)) break;
                    flows.add(this.parseDataflow(reader));
                }
            }
        }
    }

    private boolean isExternalReference(XMLStreamReader reader) {
        return "true".equals(reader.getAttributeValue(null, IS_EXTERNAL_REFERENCE_ATTR));
    }

    private Flow parseDataflow(XMLStreamReader reader) throws XMLStreamException {
        String id = reader.getAttributeValue(null, ID_ATTR);
        XMLStreamUtil.check(id != null, reader, "Missing Dataflow id", new Object[0]);
        FlowRef flowRef = FlowRef.of((String)reader.getAttributeValue(null, AGENCY_ID_ATTR), (String)id, (String)reader.getAttributeValue(null, VERSION_ATTR));
        StructureRef structRef = null;
        this.flowName.clear();
        this.flowDescription.clear();
        while (XMLStreamUtil.nextTags(reader, DATAFLOW_TAG)) {
            switch (reader.getLocalName()) {
                case "Name": {
                    this.parseTextWithLangAttr(reader, this.flowName);
                    break;
                }
                case "Description": {
                    this.parseTextWithLangAttr(reader, this.flowDescription);
                    break;
                }
                case "Structure": {
                    structRef = this.parseStructure(reader);
                }
            }
        }
        XMLStreamUtil.check(structRef != null, reader, "Missing DataStructureRef", new Object[0]);
        return Flow.builder().ref(flowRef).structureRef(structRef).name(this.flowName.build(id)).description(this.flowDescription.build()).build();
    }

    private StructureRef parseStructure(XMLStreamReader reader) throws XMLStreamException {
        if (XMLStreamUtil.nextTag(reader, STRUCTURE_TAG, REF_TAG)) {
            return this.parseRef(reader);
        }
        throw new XMLStreamException("Missing DataStructureRef");
    }

    private StructureRef parseRef(XMLStreamReader reader) throws XMLStreamException {
        String id = reader.getAttributeValue(null, ID_ATTR);
        XMLStreamUtil.check(id != null, reader, "Missing DataStructureRef id", new Object[0]);
        return StructureRef.of((String)reader.getAttributeValue(null, AGENCY_ID_ATTR), (String)id, (String)reader.getAttributeValue(null, VERSION_ATTR));
    }

    private void parseTextWithLangAttr(XMLStreamReader reader, TextBuilder langStack) throws XMLStreamException {
        String lang = reader.getAttributeValue(null, LANG_ATTR);
        if (lang != null) {
            langStack.put(lang, reader.getElementText());
        }
    }
}

