/*
 * Decompiled with CFR 0.152.
 */
package internal.sdmxdl.format.xml;

import internal.sdmxdl.format.xml.Sdmxml;
import internal.sdmxdl.format.xml.TextBuilder;
import internal.sdmxdl.format.xml.XMLStreamUtil;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import lombok.NonNull;
import sdmxdl.Flow;
import sdmxdl.FlowRef;
import sdmxdl.Languages;
import sdmxdl.StructureRef;

public final class XMLStreamFlow20 {
    private static final String HEADER_TAG = "Header";
    private static final String DATAFLOWS_TAG = "Dataflows";
    private static final String DATAFLOW_TAG = "Dataflow";
    private static final String NAME_TAG = "Name";
    private static final String DESCRIPTION_TAG = "Description";
    private static final String ID_ATTR = "id";
    private static final String AGENCY_ID_ATTR = "agencyID";
    private static final String VERSION_ATTR = "version";
    private static final String LANG_ATTR = "lang";
    private static final String KEY_FAMILY_REF_TAG = "KeyFamilyRef";
    private static final String KEY_FAMILY_ID_TAG = "KeyFamilyID";
    private static final String KEY_FAMILY_AGENCY_ID_TAG = "KeyFamilyAgencyID";
    private final TextBuilder flowName;
    private final TextBuilder flowDescription;

    public XMLStreamFlow20(Languages languages) {
        this.flowName = new TextBuilder(languages);
        this.flowDescription = new TextBuilder(languages);
    }

    @NonNull
    public List<Flow> parse(@NonNull XMLStreamReader reader) throws XMLStreamException {
        if (reader == null) {
            throw new NullPointerException("reader is marked non-null but is null");
        }
        if (XMLStreamUtil.isNotNamespaceAware(reader)) {
            throw new XMLStreamException("Cannot parse flows");
        }
        ArrayList<Flow> result = new ArrayList<Flow>();
        while (XMLStreamUtil.nextTags(reader, "")) {
            switch (reader.getLocalName()) {
                case "Header": {
                    this.parseHeader(reader);
                    break;
                }
                case "Dataflows": {
                    this.parseDataflows(reader, result);
                }
            }
        }
        return result;
    }

    private void parseHeader(XMLStreamReader reader) throws XMLStreamException {
        String ns = reader.getNamespaceURI();
        XMLStreamUtil.check(Sdmxml.MESSAGE_V20.is(ns), reader, "Invalid namespace '%s'", ns);
    }

    private void parseDataflows(XMLStreamReader reader, List<Flow> flows) throws XMLStreamException {
        while (XMLStreamUtil.nextTags(reader, DATAFLOWS_TAG)) {
            switch (reader.getLocalName()) {
                case "Dataflow": {
                    flows.add(this.parseDataflow(reader));
                }
            }
        }
    }

    private Flow parseDataflow(XMLStreamReader reader) throws XMLStreamException {
        String id = reader.getAttributeValue(null, ID_ATTR);
        XMLStreamUtil.check(id != null, reader, "Missing Dataflow id", new Object[0]);
        FlowRef flowRef = FlowRef.of((String)reader.getAttributeValue(null, AGENCY_ID_ATTR), (String)id, (String)reader.getAttributeValue(null, VERSION_ATTR));
        StructureRef structRef = null;
        this.flowName.clear();
        this.flowDescription.clear();
        while (XMLStreamUtil.nextTags(reader, DATAFLOW_TAG)) {
            switch (reader.getLocalName()) {
                case "Name": {
                    this.parseTextWithLangAttr(reader, this.flowName);
                    break;
                }
                case "Description": {
                    this.parseTextWithLangAttr(reader, this.flowDescription);
                    break;
                }
                case "KeyFamilyRef": {
                    structRef = this.parseKeyFamilyRef(reader);
                }
            }
        }
        XMLStreamUtil.check(structRef != null, reader, "Missing DataStructureRef", new Object[0]);
        return Flow.builder().ref(flowRef).structureRef(structRef).name(this.flowName.build(id)).description(this.flowDescription.build()).build();
    }

    private StructureRef parseKeyFamilyRef(XMLStreamReader reader) throws XMLStreamException {
        String agency = null;
        String id = null;
        String version = null;
        while (XMLStreamUtil.nextTags(reader, KEY_FAMILY_REF_TAG)) {
            switch (reader.getLocalName()) {
                case "KeyFamilyID": {
                    id = reader.getElementText();
                    break;
                }
                case "KeyFamilyAgencyID": {
                    agency = reader.getElementText();
                }
            }
        }
        XMLStreamUtil.check(id != null, reader, "Missing DataStructureRef id", new Object[0]);
        return StructureRef.of(agency, id, version);
    }

    private void parseTextWithLangAttr(XMLStreamReader reader, TextBuilder langStack) throws XMLStreamException {
        String lang = reader.getAttributeValue(null, LANG_ATTR);
        if (lang != null) {
            langStack.put(lang, reader.getElementText());
        }
    }
}

