/*
 * Decompiled with CFR 0.152.
 */
package internal.sdmxdl.format.xml;

import internal.sdmxdl.format.xml.AttributesBuilder;
import internal.sdmxdl.format.xml.XMLStreamUtil;
import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import lombok.NonNull;
import nbbrd.io.WrappedIOException;
import org.checkerframework.checker.nullness.qual.Nullable;
import sdmxdl.Key;
import sdmxdl.format.DataCursor;
import sdmxdl.format.ObsParser;
import sdmxdl.format.time.ObservationalTimePeriod;

public final class XMLStreamCompactDataCursor
implements DataCursor {
    private static final String DATASET_TAG = "DataSet";
    private static final String SERIES_TAG = "Series";
    private static final String OBS_TAG = "Obs";
    private final XMLStreamReader reader;
    private final Closeable onClose;
    private final Key.Builder keyBuilder;
    private final AttributesBuilder seriesAttributes;
    private final ObsParser obsParser;
    private final AttributesBuilder obsAttributes;
    private final String timeDimensionId;
    private final String primaryMeasureId;
    private boolean closed;
    private boolean hasSeries;
    private boolean hasObs;

    public XMLStreamCompactDataCursor(XMLStreamReader reader, Closeable onClose, Key.Builder keyBuilder, ObsParser obsParser, String timeDimensionId, String primaryMeasureId) {
        if (!XMLStreamUtil.isNotNamespaceAware(reader)) {
            throw new IllegalArgumentException("Using XMLStreamReader with namespace awareness");
        }
        this.reader = reader;
        this.onClose = onClose;
        this.keyBuilder = keyBuilder;
        this.seriesAttributes = new AttributesBuilder();
        this.obsParser = obsParser;
        this.obsAttributes = new AttributesBuilder();
        this.timeDimensionId = timeDimensionId;
        this.primaryMeasureId = primaryMeasureId;
        this.closed = false;
        this.hasSeries = false;
        this.hasObs = false;
    }

    public boolean nextSeries() throws IOException {
        this.checkState();
        this.keyBuilder.clear();
        this.seriesAttributes.clear();
        try {
            this.hasSeries = this.nextWhile(this::onDataSet);
            return this.hasSeries;
        }
        catch (XMLStreamException ex) {
            throw WrappedIOException.wrap((Throwable)ex);
        }
    }

    public boolean nextObs() throws IOException {
        this.checkSeriesState();
        this.obsParser.clear();
        this.obsAttributes.clear();
        try {
            this.hasObs = this.nextWhile(this::onSeriesBody);
            return this.hasObs;
        }
        catch (XMLStreamException ex) {
            throw WrappedIOException.wrap((Throwable)ex);
        }
    }

    @NonNull
    public Key getSeriesKey() throws IOException {
        this.checkSeriesState();
        if (!this.keyBuilder.isSeries()) {
            throw new IOException("Invalid series key '" + this.keyBuilder + "'");
        }
        return this.keyBuilder.build();
    }

    public String getSeriesAttribute(@NonNull String key) throws IOException {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        this.checkSeriesState();
        return this.seriesAttributes.getAttribute(key);
    }

    @NonNull
    public Map<String, String> getSeriesAttributes() throws IOException {
        this.checkSeriesState();
        return this.seriesAttributes.build();
    }

    public ObservationalTimePeriod getObsPeriod() throws IOException {
        this.checkObsState();
        return this.obsParser.parsePeriod();
    }

    public Double getObsValue() throws IOException {
        this.checkObsState();
        return this.obsParser.parseValue();
    }

    @NonNull
    public Map<String, String> getObsAttributes() throws IOException {
        this.checkObsState();
        return this.obsAttributes.build();
    }

    public @Nullable String getObsAttribute(@NonNull String key) throws IOException, IllegalStateException {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        this.checkObsState();
        return this.obsAttributes.getAttribute(key);
    }

    public void close() throws IOException {
        this.closed = true;
        XMLStreamUtil.closeBoth(this.reader, this.onClose);
    }

    private void checkState() throws IOException {
        if (this.closed) {
            throw new IOException("Cursor closed");
        }
    }

    private void checkSeriesState() throws IOException, IllegalStateException {
        this.checkState();
        if (!this.hasSeries) {
            throw new IllegalStateException();
        }
    }

    private void checkObsState() throws IOException, IllegalStateException {
        this.checkSeriesState();
        if (!this.hasObs) {
            throw new IllegalStateException();
        }
    }

    private XMLStreamUtil.Status onDataSet(boolean start, String localName) {
        if (start) {
            return XMLStreamUtil.isTagMatch(localName, SERIES_TAG) ? this.parseSeries() : XMLStreamUtil.Status.CONTINUE;
        }
        return XMLStreamUtil.isTagMatch(localName, DATASET_TAG) ? XMLStreamUtil.Status.HALT : XMLStreamUtil.Status.CONTINUE;
    }

    private XMLStreamUtil.Status parseSeries() {
        if (this.isValidSeriesHead()) {
            this.parserSeriesHead();
            return XMLStreamUtil.Status.SUSPEND;
        }
        return XMLStreamUtil.Status.CONTINUE;
    }

    private boolean isValidSeriesHead() {
        return this.reader.getAttributeCount() > 0;
    }

    private void parserSeriesHead() {
        for (int i = 0; i < this.reader.getAttributeCount(); ++i) {
            String id = this.reader.getAttributeName(i).getLocalPart();
            if (this.keyBuilder.isDimension(id)) {
                this.keyBuilder.put(id, this.reader.getAttributeValue(i));
                continue;
            }
            this.seriesAttributes.put(id, this.reader.getAttributeValue(i));
        }
    }

    private XMLStreamUtil.Status onSeriesBody(boolean start, String localName) {
        if (start) {
            return XMLStreamUtil.isTagMatch(localName, OBS_TAG) ? this.parseObs() : XMLStreamUtil.Status.CONTINUE;
        }
        return XMLStreamUtil.isTagMatch(localName, SERIES_TAG) ? XMLStreamUtil.Status.HALT : XMLStreamUtil.Status.CONTINUE;
    }

    private XMLStreamUtil.Status parseObs() {
        for (int i = 0; i < this.reader.getAttributeCount(); ++i) {
            String name = this.reader.getAttributeLocalName(i);
            String value = this.reader.getAttributeValue(i);
            if (this.timeDimensionId.equals(name)) {
                this.obsParser.period(value);
                continue;
            }
            if (this.primaryMeasureId.equals(name)) {
                this.obsParser.value(value);
                continue;
            }
            this.obsAttributes.put(name, value);
        }
        return XMLStreamUtil.Status.SUSPEND;
    }

    private boolean nextWhile(XMLStreamUtil.TagVisitor func) throws XMLStreamException {
        return XMLStreamUtil.nextWhile(this.reader, func);
    }
}

