/*
 * Decompiled with CFR 0.152.
 */
package internal.sdmxdl.format.xml;

import java.util.LinkedHashMap;
import java.util.Map;
import lombok.Generated;
import lombok.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import sdmxdl.Languages;

final class TextBuilder {
    @NonNull
    private final Languages ranges;
    private final Map<String, String> data = new LinkedHashMap<String, String>();

    @NonNull
    public TextBuilder clear() {
        this.data.clear();
        return this;
    }

    @NonNull
    public TextBuilder put(@NonNull String lang, @Nullable String text) {
        if (lang == null) {
            throw new NullPointerException("lang is marked non-null but is null");
        }
        if (text != null) {
            this.data.put(lang, text);
        }
        return this;
    }

    public @Nullable String build() {
        return this.ranges.select(this.data);
    }

    @NonNull
    public String build(@NonNull String defaultValue) {
        if (defaultValue == null) {
            throw new NullPointerException("defaultValue is marked non-null but is null");
        }
        String result = this.build();
        return result != null ? result : defaultValue;
    }

    @Generated
    public TextBuilder(@NonNull Languages ranges) {
        if (ranges == null) {
            throw new NullPointerException("ranges is marked non-null but is null");
        }
        this.ranges = ranges;
    }
}

