/*
 * Decompiled with CFR 0.152.
 */
package internal.sdmxdl.format.xml;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import lombok.NonNull;
import nbbrd.io.net.MediaType;
import org.checkerframework.checker.nullness.qual.Nullable;
import sdmxdl.Codelist;
import sdmxdl.CodelistRef;
import sdmxdl.Dimension;
import sdmxdl.Structure;
import sdmxdl.StructureRef;
import sdmxdl.format.xml.XmlMediaTypes;

public final class CustomDataStructureBuilder {
    private final LinkedHashMap<String, Set<String>> dimensions = new LinkedHashMap();
    private final LinkedHashMap<String, Set<String>> attributes = new LinkedHashMap();
    private MediaType fileType = null;
    private StructureRef ref = null;
    private String timeDimensionId = null;
    private String primaryMeasureId = null;
    private static final Pattern WHITE_SPACE_PATTERN = Pattern.compile("\\s+");

    @NonNull
    public CustomDataStructureBuilder dimension(@NonNull String concept, @NonNull String value) {
        if (concept == null) {
            throw new NullPointerException("concept is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        CustomDataStructureBuilder.putMulti(this.dimensions, concept, value);
        return this;
    }

    @NonNull
    public CustomDataStructureBuilder attribute(@NonNull String concept, @NonNull String value) {
        if (concept == null) {
            throw new NullPointerException("concept is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        CustomDataStructureBuilder.putMulti(this.attributes, concept, value);
        return this;
    }

    @NonNull
    public CustomDataStructureBuilder fileType(@NonNull MediaType fileType) {
        if (fileType == null) {
            throw new NullPointerException("fileType is marked non-null but is null");
        }
        this.fileType = fileType;
        return this;
    }

    @NonNull
    public CustomDataStructureBuilder refId(@NonNull String refId) {
        if (refId == null) {
            throw new NullPointerException("refId is marked non-null but is null");
        }
        return this.ref(StructureRef.of(null, (String)refId, null));
    }

    @NonNull
    public CustomDataStructureBuilder ref(@NonNull StructureRef ref) {
        if (ref == null) {
            throw new NullPointerException("ref is marked non-null but is null");
        }
        this.ref = ref;
        return this;
    }

    @NonNull
    public CustomDataStructureBuilder timeDimensionId(@Nullable String timeDimensionId) {
        this.timeDimensionId = timeDimensionId;
        return this;
    }

    @NonNull
    public CustomDataStructureBuilder primaryMeasureId(@Nullable String primaryMeasureId) {
        this.primaryMeasureId = primaryMeasureId;
        return this;
    }

    @NonNull
    public Structure build() {
        return Structure.builder().ref(this.ref).dimensions(this.guessDimensions()).name(this.ref.getId()).timeDimensionId(this.timeDimensionId != null ? this.timeDimensionId : "TIME_PERIOD").primaryMeasureId(this.primaryMeasureId != null ? this.primaryMeasureId : "OBS_VALUE").build();
    }

    private Set<Dimension> guessDimensions() {
        LinkedHashSet<Dimension> result = new LinkedHashSet<Dimension>();
        int position = 1;
        boolean needsFiltering = this.fileType.equals((Object)XmlMediaTypes.STRUCTURE_SPECIFIC_DATA_20) || this.fileType.equals((Object)XmlMediaTypes.STRUCTURE_SPECIFIC_DATA_21);
        for (Map.Entry<String, Set<String>> item : this.dimensions.entrySet()) {
            if (needsFiltering && this.isAttribute(item)) continue;
            result.add(CustomDataStructureBuilder.dimension(item.getKey(), position++, (Collection<String>)item.getValue()));
        }
        return result;
    }

    private boolean isAttribute(Map.Entry<String, Set<String>> item) {
        if (item.getKey().contains("TITLE")) {
            return true;
        }
        return item.getValue().stream().anyMatch(o -> WHITE_SPACE_PATTERN.matcher((CharSequence)o).find());
    }

    private static void putMulti(Map<String, Set<String>> map, String key, String value) {
        map.computeIfAbsent(key, k -> new HashSet()).add(value);
    }

    public static Dimension dimension(String name, int pos, String ... values) {
        return CustomDataStructureBuilder.dimension(name, pos, Arrays.asList(values));
    }

    public static Dimension dimension(String name, int pos, Collection<String> values) {
        Codelist.Builder codelist = Codelist.builder().ref(CodelistRef.parse((CharSequence)name));
        values.forEach(o -> codelist.code(o, o));
        return Dimension.builder().id(name).position(pos).name(name).codelist(codelist.build()).build();
    }
}

