/*
 * Decompiled with CFR 0.152.
 */
package internal.sdmxdl.format.xml;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import lombok.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

final class AttributesBuilder {
    private final Map<String, String> data = new HashMap<String, String>();

    AttributesBuilder() {
    }

    @NonNull
    AttributesBuilder clear() {
        this.data.clear();
        return this;
    }

    @NonNull
    AttributesBuilder put(@Nullable String key, @Nullable String value) {
        if (key != null && value != null) {
            this.data.put(key, value);
        }
        return this;
    }

    @Nullable String getAttribute(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.data.get(key);
    }

    @NonNull
    Map<String, String> build() {
        switch (this.data.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<String, String> single = this.data.entrySet().iterator().next();
                return Collections.singletonMap(single.getKey(), single.getValue());
            }
        }
        return Collections.unmodifiableMap(new HashMap<String, String>(this.data));
    }
}

