/*
 * Decompiled with CFR 0.152.
 */
package sdmxdl.csv;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Locale;
import lombok.Generated;
import nbbrd.io.text.Formatter;
import nbbrd.io.text.Parser;
import org.checkerframework.checker.nullness.qual.NonNull;
import sdmxdl.DataflowRef;
import sdmxdl.Frequency;
import sdmxdl.Series;

public final class SdmxCsvFields {
    public static final String DATAFLOW = "DATAFLOW";
    public static final String KEY_DIMENSIONS = "KEY_DIMENSIONS";
    public static final String TIME_DIMENSION = "TIME_DIMENSION";
    public static final String OBS_VALUE = "OBS_VALUE";
    public static final String ATTRIBUTES = "ATTRIBUTES";
    public static final String SERIESKEY = "SERIESKEY";

    public static @NonNull Formatter<DataflowRef> getDataflowRefFormatter() {
        return SdmxCsvFields::formatDataflowField;
    }

    public static @NonNull Parser<DataflowRef> getDataflowRefParser() {
        return SdmxCsvFields::parseDataflowField;
    }

    public static @NonNull Formatter<Number> getValueFormatter(@NonNull Locale locale) {
        return Formatter.onNumberFormat((NumberFormat)SdmxCsvFields.getNumberFormat(locale));
    }

    public static @NonNull Formatter<LocalDateTime> getPeriodFormatter(@NonNull Collection<Series> data) {
        return Formatter.onDateTimeFormatter((DateTimeFormatter)SdmxCsvFields.getDateTimeFormatter(Frequency.getHighest(data)));
    }

    private static NumberFormat getNumberFormat(Locale encoding) {
        DecimalFormat decimalFormat = new DecimalFormat("", DecimalFormatSymbols.getInstance(encoding));
        decimalFormat.setGroupingUsed(false);
        return decimalFormat;
    }

    private static DateTimeFormatter getDateTimeFormatter(Frequency freq) {
        switch (freq) {
            case ANNUAL: {
                return DateTimeFormatter.ofPattern("yyyy");
            }
            case HALF_YEARLY: 
            case QUARTERLY: 
            case MONTHLY: {
                return DateTimeFormatter.ofPattern("yyyy-MM");
            }
            case WEEKLY: 
            case DAILY: 
            case DAILY_BUSINESS: {
                return DateTimeFormatter.ofPattern("yyyy-MM-dd");
            }
            case HOURLY: {
                return DateTimeFormatter.ofPattern("yyyy-MM-ddTHH");
            }
            case MINUTELY: {
                return DateTimeFormatter.ofPattern("yyyy-MM-ddTHH:mm");
            }
            case UNDEFINED: {
                return DateTimeFormatter.ISO_DATE_TIME;
            }
        }
        throw new RuntimeException();
    }

    private static String formatDataflowField(DataflowRef ref) {
        return ref != null ? ref.getAgency() + ":" + ref.getId() + "(" + ref.getVersion() + ")" : null;
    }

    private static DataflowRef parseDataflowField(CharSequence ref) {
        if (ref == null) {
            return null;
        }
        String text = ref.toString();
        int idx1 = text.indexOf(58);
        if (idx1 == -1) {
            return null;
        }
        int idx2 = text.indexOf(40, idx1);
        if (idx2 == -1) {
            return null;
        }
        int idx3 = text.indexOf(41, idx2);
        if (idx3 == -1) {
            return null;
        }
        if (idx3 != text.length() - 1) {
            return null;
        }
        return DataflowRef.of((String)text.substring(0, idx1), (String)text.substring(idx1 + 1, idx2), (String)text.substring(idx2 + 1, idx3));
    }

    @Generated
    private SdmxCsvFields() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

