/*
 * Decompiled with CFR 0.152.
 */
package sdmxdl.csv;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import nbbrd.io.text.Parser;
import nbbrd.io.text.TextBuffers;
import nbbrd.io.text.TextParser;
import nbbrd.picocsv.Csv;
import sdmxdl.Attribute;
import sdmxdl.DataStructure;
import sdmxdl.DataflowRef;
import sdmxdl.Key;
import sdmxdl.Obs;
import sdmxdl.Series;
import sdmxdl.csv.SdmxCsvFields;
import sdmxdl.ext.ObsFactory;
import sdmxdl.ext.ObsParser;
import sdmxdl.repo.DataSet;

public final class SdmxPicocsvParser
implements TextParser<DataSet> {
    @NonNull
    private final DataStructure dsd;
    @NonNull
    private final ObsFactory factory;
    @NonNull
    private final Csv.Format format;
    @NonNull
    private final Csv.ReaderOptions options;
    @NonNull
    private final Locale locale;

    public @org.checkerframework.checker.nullness.qual.NonNull DataSet parseReader(@org.checkerframework.checker.nullness.qual.NonNull Reader reader) throws IOException {
        try (Csv.Reader csv = this.newCsvReader(reader, TextBuffers.UNKNOWN);){
            DataSet dataSet = this.parse(csv);
            return dataSet;
        }
    }

    public @org.checkerframework.checker.nullness.qual.NonNull DataSet parseStream(@org.checkerframework.checker.nullness.qual.NonNull InputStream stream, @org.checkerframework.checker.nullness.qual.NonNull Charset charset) throws IOException {
        CharsetDecoder decoder = charset.newDecoder();
        try (Csv.Reader csv = this.newCsvReader(SdmxPicocsvParser.newBufferedReader(stream, decoder), TextBuffers.of((InputStream)stream, (CharsetDecoder)decoder));){
            DataSet dataSet = this.parse(csv);
            return dataSet;
        }
    }

    public @org.checkerframework.checker.nullness.qual.NonNull DataSet parse(// Could not load outer class - annotation placement on inner may be incorrect
     @org.checkerframework.checker.nullness.qual.NonNull Csv.Reader reader) throws IOException {
        List<String> header = this.readHeader(reader);
        int minHeaderSize = 3 + this.dsd.getDimensions().size();
        if (header.size() < minHeaderSize) {
            throw new IOException("Invalid header size");
        }
        if (!"DATAFLOW".equals(header.get(0))) {
            throw new IOException("Invalid dataflow header");
        }
        if (!this.dsd.getTimeDimensionId().equals(header.get(1 + this.dsd.getDimensions().size()))) {
            throw new IOException("Invalid time dimension header");
        }
        if (!"OBS_VALUE".equals(header.get(1 + this.dsd.getDimensions().size() + 1))) {
            throw new IOException("Invalid obs value header");
        }
        int seriesKeyIndex = header.subList(minHeaderSize, header.size()).indexOf("SERIESKEY");
        if (seriesKeyIndex != -1) {
            Map attributes = this.dsd.getAttributes().stream().collect(Collectors.toMap(Attribute::getId, Function.identity()));
            for (int i = minHeaderSize; i < seriesKeyIndex; ++i) {
                String attributeId = header.get(i);
                if (attributes.containsKey(attributeId)) continue;
                throw new IOException("Unknown attribute header");
            }
        }
        ObsParser obsParser = this.factory.getObsParser(this.dsd);
        Parser<DataflowRef> refParser = SdmxCsvFields.getDataflowRefParser();
        DataflowRef dataflowRef = DataflowRef.of(null, (String)"", null);
        HashMap<Key, Series.Builder> data = new HashMap<Key, Series.Builder>();
        Key.Builder keyBuilder = Key.builder((DataStructure)this.dsd);
        Obs.Builder obs = Obs.builder();
        while (SdmxPicocsvParser.skipComments(reader)) {
            if (!reader.readField()) {
                throw new IOException("Missing dataflow field");
            }
            dataflowRef = (DataflowRef)refParser.parse((CharSequence)reader);
            keyBuilder.clear();
            for (int i = 0; i < keyBuilder.size(); ++i) {
                if (!reader.readField()) {
                    throw new IOException("Missing dimension field");
                }
                keyBuilder.put(header.get(1 + i), reader.toString());
            }
            if (!reader.readField()) {
                throw new IOException("Missing time dimension field");
            }
            obsParser.period(reader.toString());
            if (!reader.readField()) {
                throw new IOException("Missing obs value field");
            }
            obsParser.value(reader.toString());
            Series.Builder series = data.computeIfAbsent(keyBuilder.build(), z -> Series.builder().key(z).freq(obsParser.frequency(keyBuilder, o -> null).getFrequency()));
            series.obs(obs.clearMeta().period(obsParser.parsePeriod()).value(obsParser.parseValue()).build());
        }
        return DataSet.builder().ref(dataflowRef).data((Collection)data.values().stream().map(Series.Builder::build).collect(Collectors.toList())).build();
    }

    private List<String> readHeader(Csv.Reader reader) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        if (!SdmxPicocsvParser.skipComments(reader)) {
            throw new IOException("Missing header");
        }
        while (reader.readField()) {
            result.add(reader.toString());
        }
        return result;
    }

    private Csv.Reader newCsvReader(Reader charReader, TextBuffers buffers) throws IOException {
        return Csv.Reader.of((Csv.Format)this.format, (Csv.ReaderOptions)this.options, (Reader)charReader, (int)buffers.getCharBufferSize());
    }

    private static BufferedReader newBufferedReader(InputStream inputStream, CharsetDecoder decoder) {
        return new BufferedReader(new InputStreamReader(inputStream, decoder));
    }

    private static boolean skipComments(Csv.Reader reader) throws IOException {
        while (reader.readLine()) {
            if (reader.isComment()) continue;
            return true;
        }
        return false;
    }

    @Generated
    private static Csv.Format $default$format() {
        return Csv.Format.RFC4180;
    }

    @Generated
    private static Csv.ReaderOptions $default$options() {
        return Csv.ReaderOptions.DEFAULT;
    }

    @Generated
    private static Locale $default$locale() {
        return Locale.ROOT;
    }

    @Generated
    SdmxPicocsvParser(@NonNull DataStructure dsd, @NonNull ObsFactory factory, @NonNull Csv.Format format, @NonNull Csv.ReaderOptions options, @NonNull Locale locale) {
        if (dsd == null) {
            throw new NullPointerException("dsd is marked non-null but is null");
        }
        if (factory == null) {
            throw new NullPointerException("factory is marked non-null but is null");
        }
        if (format == null) {
            throw new NullPointerException("format is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        if (locale == null) {
            throw new NullPointerException("locale is marked non-null but is null");
        }
        this.dsd = dsd;
        this.factory = factory;
        this.format = format;
        this.options = options;
        this.locale = locale;
    }

    @Generated
    public static @org.checkerframework.checker.nullness.qual.NonNull Builder builder() {
        return new Builder();
    }

    @Generated
    public @org.checkerframework.checker.nullness.qual.NonNull Builder toBuilder() {
        return new Builder().dsd(this.dsd).factory(this.factory).format(this.format).options(this.options).locale(this.locale);
    }

    @Generated
    public static class Builder {
        @Generated
        private DataStructure dsd;
        @Generated
        private ObsFactory factory;
        @Generated
        private boolean format$set;
        @Generated
        private Csv.Format format$value;
        @Generated
        private boolean options$set;
        @Generated
        private Csv.ReaderOptions options$value;
        @Generated
        private boolean locale$set;
        @Generated
        private Locale locale$value;

        @Generated
        Builder() {
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull Builder dsd(@NonNull DataStructure dsd) {
            if (dsd == null) {
                throw new NullPointerException("dsd is marked non-null but is null");
            }
            this.dsd = dsd;
            return this;
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull Builder factory(@NonNull ObsFactory factory) {
            if (factory == null) {
                throw new NullPointerException("factory is marked non-null but is null");
            }
            this.factory = factory;
            return this;
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull Builder format(@NonNull Csv.Format format) {
            if (format == null) {
                throw new NullPointerException("format is marked non-null but is null");
            }
            this.format$value = format;
            this.format$set = true;
            return this;
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull Builder options(@NonNull Csv.ReaderOptions options) {
            if (options == null) {
                throw new NullPointerException("options is marked non-null but is null");
            }
            this.options$value = options;
            this.options$set = true;
            return this;
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull Builder locale(@NonNull Locale locale) {
            if (locale == null) {
                throw new NullPointerException("locale is marked non-null but is null");
            }
            this.locale$value = locale;
            this.locale$set = true;
            return this;
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull SdmxPicocsvParser build() {
            Csv.Format format$value = this.format$value;
            if (!this.format$set) {
                format$value = SdmxPicocsvParser.$default$format();
            }
            Csv.ReaderOptions options$value = this.options$value;
            if (!this.options$set) {
                options$value = SdmxPicocsvParser.$default$options();
            }
            Locale locale$value = this.locale$value;
            if (!this.locale$set) {
                locale$value = SdmxPicocsvParser.$default$locale();
            }
            return new SdmxPicocsvParser(this.dsd, this.factory, format$value, options$value, locale$value);
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull String toString() {
            return "SdmxPicocsvParser.Builder(dsd=" + this.dsd + ", factory=" + this.factory + ", format$value=" + this.format$value + ", options$value=" + this.options$value + ", locale$value=" + this.locale$value + ")";
        }
    }
}

