/*
 * Decompiled with CFR 0.152.
 */
package sdmxdl.csv;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import lombok.Generated;
import lombok.NonNull;
import nbbrd.io.function.IOConsumer;
import nbbrd.io.text.TextBuffers;
import nbbrd.io.text.TextFormatter;
import nbbrd.picocsv.Csv;
import sdmxdl.DataStructure;
import sdmxdl.Obs;
import sdmxdl.Series;
import sdmxdl.csv.SdmxCsvFieldWriter;
import sdmxdl.csv.SdmxCsvFields;
import sdmxdl.repo.DataSet;

public final class SdmxPicocsvFormatter
implements TextFormatter<DataSet> {
    @NonNull
    private final DataStructure dsd;
    private final List<String> fields;
    private final Map<String, Function<DataSet, SdmxCsvFieldWriter>> customFactories;
    @NonNull
    private final Csv.Format format;
    @NonNull
    private final Csv.WriterOptions options;
    @NonNull
    private final Locale locale;
    private final boolean ignoreHeader;

    public void formatWriter(DataSet data, Writer charWriter) throws IOException {
        try (Csv.Writer csv = this.newCsvWriter(charWriter, TextBuffers.UNKNOWN);){
            this.format(data, csv);
        }
    }

    public void formatStream(DataSet data, OutputStream stream, Charset charset) throws IOException {
        CharsetEncoder encoder = charset.newEncoder();
        try (Csv.Writer csv = this.newCsvWriter(SdmxPicocsvFormatter.newBufferedWriter(stream, encoder), TextBuffers.of((OutputStream)stream, (CharsetEncoder)encoder));){
            this.format(data, csv);
        }
    }

    public void format(@org.checkerframework.checker.nullness.qual.NonNull DataSet data, // Could not load outer class - annotation placement on inner may be incorrect
     @org.checkerframework.checker.nullness.qual.NonNull Csv.Writer w) throws IOException {
        SdmxCsvFieldWriter[] writers = (SdmxCsvFieldWriter[])this.fields.stream().map(field -> this.getFieldWriter(data, (String)field)).toArray(SdmxCsvFieldWriter[]::new);
        if (!this.ignoreHeader) {
            for (SdmxCsvFieldWriter writer : writers) {
                writer.writeHead((IOConsumer<CharSequence>)((IOConsumer)arg_0 -> ((Csv.Writer)w).writeField(arg_0)));
            }
            w.writeEndOfLine();
        }
        for (Series series : data.getData()) {
            for (Obs obs : series.getObs()) {
                for (SdmxCsvFieldWriter writer : writers) {
                    writer.writeBody(series, obs, (IOConsumer<CharSequence>)((IOConsumer)arg_0 -> ((Csv.Writer)w).writeField(arg_0)));
                }
                w.writeEndOfLine();
            }
        }
    }

    private Csv.Writer newCsvWriter(Writer charWriter, TextBuffers buffers) throws IOException {
        return Csv.Writer.of((Csv.Format)this.format, (Csv.WriterOptions)this.options, (Writer)charWriter, (int)buffers.getCharBufferSize());
    }

    private SdmxCsvFieldWriter getFieldWriter(DataSet dataSet, String field) {
        Function<DataSet, SdmxCsvFieldWriter> factory = this.customFactories.get(field);
        if (factory == null) {
            factory = this.getDefaultFactory(field);
        }
        return factory.apply(dataSet);
    }

    private Function<DataSet, SdmxCsvFieldWriter> getDefaultFactory(String field) {
        switch (field) {
            case "DATAFLOW": {
                return dataSet -> SdmxCsvFieldWriter.onDataflow("DATAFLOW", dataSet.getRef());
            }
            case "KEY_DIMENSIONS": {
                return dataSet -> SdmxCsvFieldWriter.onKeyDimensions(this.dsd);
            }
            case "TIME_DIMENSION": {
                return dataSet -> SdmxCsvFieldWriter.onTimeDimension(this.dsd, SdmxCsvFields.getPeriodFormatter(dataSet.getData()));
            }
            case "OBS_VALUE": {
                return dataSet -> SdmxCsvFieldWriter.onObsValue("OBS_VALUE", SdmxCsvFields.getValueFormatter(this.locale));
            }
            case "ATTRIBUTES": {
                return dataSet -> SdmxCsvFieldWriter.onAttributes(this.dsd);
            }
            case "SERIESKEY": {
                return dataSet -> SdmxCsvFieldWriter.onSeriesKey("SERIESKEY");
            }
        }
        return dataSet -> SdmxCsvFieldWriter.onConstant(field, "");
    }

    private static BufferedWriter newBufferedWriter(OutputStream outputStream, CharsetEncoder encoder) {
        return new BufferedWriter(new OutputStreamWriter(outputStream, encoder));
    }

    @Generated
    private static List<String> $default$fields() {
        return Arrays.asList("DATAFLOW", "KEY_DIMENSIONS", "TIME_DIMENSION", "OBS_VALUE", "ATTRIBUTES", "SERIESKEY");
    }

    @Generated
    private static Csv.Format $default$format() {
        return Csv.Format.RFC4180;
    }

    @Generated
    private static Csv.WriterOptions $default$options() {
        return Csv.WriterOptions.DEFAULT;
    }

    @Generated
    private static Locale $default$locale() {
        return Locale.ROOT;
    }

    @Generated
    private static boolean $default$ignoreHeader() {
        return false;
    }

    @Generated
    SdmxPicocsvFormatter(@NonNull DataStructure dsd, List<String> fields, Map<String, Function<DataSet, SdmxCsvFieldWriter>> customFactories, @NonNull Csv.Format format, @NonNull Csv.WriterOptions options, @NonNull Locale locale, boolean ignoreHeader) {
        if (dsd == null) {
            throw new NullPointerException("dsd is marked non-null but is null");
        }
        if (format == null) {
            throw new NullPointerException("format is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        if (locale == null) {
            throw new NullPointerException("locale is marked non-null but is null");
        }
        this.dsd = dsd;
        this.fields = fields;
        this.customFactories = customFactories;
        this.format = format;
        this.options = options;
        this.locale = locale;
        this.ignoreHeader = ignoreHeader;
    }

    @Generated
    public static @org.checkerframework.checker.nullness.qual.NonNull Builder builder() {
        return new Builder();
    }

    @Generated
    public @org.checkerframework.checker.nullness.qual.NonNull Builder toBuilder() {
        Builder builder = new Builder().dsd(this.dsd).fields(this.fields).format(this.format).options(this.options).locale(this.locale).ignoreHeader(this.ignoreHeader);
        if (this.customFactories != null) {
            builder.customFactories(this.customFactories);
        }
        return builder;
    }

    @Generated
    public static class Builder {
        @Generated
        private DataStructure dsd;
        @Generated
        private boolean fields$set;
        @Generated
        private List<String> fields$value;
        @Generated
        private ArrayList<String> customFactories$key;
        @Generated
        private ArrayList<Function<DataSet, SdmxCsvFieldWriter>> customFactories$value;
        @Generated
        private boolean format$set;
        @Generated
        private Csv.Format format$value;
        @Generated
        private boolean options$set;
        @Generated
        private Csv.WriterOptions options$value;
        @Generated
        private boolean locale$set;
        @Generated
        private Locale locale$value;
        @Generated
        private boolean ignoreHeader$set;
        @Generated
        private boolean ignoreHeader$value;

        @Generated
        Builder() {
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull Builder dsd(@NonNull DataStructure dsd) {
            if (dsd == null) {
                throw new NullPointerException("dsd is marked non-null but is null");
            }
            this.dsd = dsd;
            return this;
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull Builder fields(List<String> fields) {
            this.fields$value = fields;
            this.fields$set = true;
            return this;
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull Builder customFactory(String customFactoryKey, Function<DataSet, SdmxCsvFieldWriter> customFactoryValue) {
            if (this.customFactories$key == null) {
                this.customFactories$key = new ArrayList();
                this.customFactories$value = new ArrayList();
            }
            this.customFactories$key.add(customFactoryKey);
            this.customFactories$value.add(customFactoryValue);
            return this;
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull Builder customFactories(@org.checkerframework.checker.nullness.qual.NonNull Map<? extends String, ? extends Function<DataSet, SdmxCsvFieldWriter>> customFactories) {
            if (customFactories == null) {
                throw new NullPointerException("customFactories cannot be null");
            }
            if (this.customFactories$key == null) {
                this.customFactories$key = new ArrayList();
                this.customFactories$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends Function<DataSet, SdmxCsvFieldWriter>> $lombokEntry : customFactories.entrySet()) {
                this.customFactories$key.add($lombokEntry.getKey());
                this.customFactories$value.add($lombokEntry.getValue());
            }
            return this;
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull Builder clearCustomFactories() {
            if (this.customFactories$key != null) {
                this.customFactories$key.clear();
                this.customFactories$value.clear();
            }
            return this;
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull Builder format(@NonNull Csv.Format format) {
            if (format == null) {
                throw new NullPointerException("format is marked non-null but is null");
            }
            this.format$value = format;
            this.format$set = true;
            return this;
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull Builder options(@NonNull Csv.WriterOptions options) {
            if (options == null) {
                throw new NullPointerException("options is marked non-null but is null");
            }
            this.options$value = options;
            this.options$set = true;
            return this;
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull Builder locale(@NonNull Locale locale) {
            if (locale == null) {
                throw new NullPointerException("locale is marked non-null but is null");
            }
            this.locale$value = locale;
            this.locale$set = true;
            return this;
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull Builder ignoreHeader(boolean ignoreHeader) {
            this.ignoreHeader$value = ignoreHeader;
            this.ignoreHeader$set = true;
            return this;
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull SdmxPicocsvFormatter build() {
            Map<Object, Object> customFactories;
            switch (this.customFactories$key == null ? 0 : this.customFactories$key.size()) {
                case 0: {
                    customFactories = Collections.emptyMap();
                    break;
                }
                case 1: {
                    customFactories = Collections.singletonMap(this.customFactories$key.get(0), this.customFactories$value.get(0));
                    break;
                }
                default: {
                    customFactories = new LinkedHashMap(this.customFactories$key.size() < 0x40000000 ? 1 + this.customFactories$key.size() + (this.customFactories$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.customFactories$key.size(); ++$i) {
                        customFactories.put(this.customFactories$key.get($i), this.customFactories$value.get($i));
                    }
                    customFactories = Collections.unmodifiableMap(customFactories);
                }
            }
            List fields$value = this.fields$value;
            if (!this.fields$set) {
                fields$value = SdmxPicocsvFormatter.$default$fields();
            }
            Csv.Format format$value = this.format$value;
            if (!this.format$set) {
                format$value = SdmxPicocsvFormatter.$default$format();
            }
            Csv.WriterOptions options$value = this.options$value;
            if (!this.options$set) {
                options$value = SdmxPicocsvFormatter.$default$options();
            }
            Locale locale$value = this.locale$value;
            if (!this.locale$set) {
                locale$value = SdmxPicocsvFormatter.$default$locale();
            }
            boolean ignoreHeader$value = this.ignoreHeader$value;
            if (!this.ignoreHeader$set) {
                ignoreHeader$value = SdmxPicocsvFormatter.$default$ignoreHeader();
            }
            return new SdmxPicocsvFormatter(this.dsd, fields$value, customFactories, format$value, options$value, locale$value, ignoreHeader$value);
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull String toString() {
            return "SdmxPicocsvFormatter.Builder(dsd=" + this.dsd + ", fields$value=" + this.fields$value + ", customFactories$key=" + this.customFactories$key + ", customFactories$value=" + this.customFactories$value + ", format$value=" + this.format$value + ", options$value=" + this.options$value + ", locale$value=" + this.locale$value + ", ignoreHeader$value=" + this.ignoreHeader$value + ")";
        }
    }
}

