/*
 * Decompiled with CFR 0.152.
 */
package sdmxdl.csv;

import java.io.IOException;
import java.time.LocalDateTime;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import nbbrd.io.function.IOConsumer;
import nbbrd.io.text.Formatter;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import sdmxdl.Attribute;
import sdmxdl.DataStructure;
import sdmxdl.DataflowRef;
import sdmxdl.Dimension;
import sdmxdl.Obs;
import sdmxdl.Series;
import sdmxdl.csv.SdmxCsvFields;

public interface SdmxCsvFieldWriter {
    public void writeHead(@NonNull IOConsumer<CharSequence> var1) throws IOException;

    public void writeBody(@NonNull Series var1, @NonNull Obs var2, @NonNull IOConsumer<CharSequence> var3) throws IOException;

    public static @NonNull SdmxCsvFieldWriter single(final @NonNull String label, final @NonNull SingleField value) {
        Objects.requireNonNull(label);
        Objects.requireNonNull(value);
        return new SdmxCsvFieldWriter(){

            @Override
            public void writeHead(IOConsumer<CharSequence> output) throws IOException {
                output.acceptWithIO((Object)label);
            }

            @Override
            public void writeBody(Series series, Obs obs, IOConsumer<CharSequence> output) throws IOException {
                output.acceptWithIO((Object)value.apply(series, obs));
            }
        };
    }

    public static @NonNull SdmxCsvFieldWriter multi(final @NonNull List<String> labels, final @NonNull MultiField values) {
        Objects.requireNonNull(labels);
        Objects.requireNonNull(values);
        return new SdmxCsvFieldWriter(){

            @Override
            public void writeHead(IOConsumer<CharSequence> output) throws IOException {
                for (String label : labels) {
                    output.acceptWithIO((Object)label);
                }
            }

            @Override
            public void writeBody(Series series, Obs obs, IOConsumer<CharSequence> output) throws IOException {
                for (int i = 0; i < labels.size(); ++i) {
                    output.acceptWithIO((Object)values.apply(series, obs, i));
                }
            }
        };
    }

    public static @NonNull SdmxCsvFieldWriter onDataflow(@NonNull String label, @NonNull DataflowRef ref) {
        Objects.requireNonNull(ref);
        String dataflow = SdmxCsvFields.getDataflowRefFormatter().formatAsString((Object)ref);
        return SdmxCsvFieldWriter.single(label, (series, obs) -> dataflow);
    }

    public static @NonNull SdmxCsvFieldWriter onKeyDimensions(@NonNull DataStructure dsd) {
        return SdmxCsvFieldWriter.onKeyDimensions(dsd.getDimensions().stream().sorted(Comparator.comparingInt(Dimension::getPosition)).map(Dimension::getId).collect(Collectors.toList()));
    }

    public static @NonNull SdmxCsvFieldWriter onKeyDimensions(@NonNull List<String> labels) {
        return SdmxCsvFieldWriter.multi(labels, (series, obs, i) -> series.getKey().get(i));
    }

    public static @NonNull SdmxCsvFieldWriter onTimeDimension(@NonNull DataStructure dsd, @NonNull Formatter<LocalDateTime> formatter) {
        return SdmxCsvFieldWriter.onTimeDimension(dsd.getTimeDimensionId(), formatter);
    }

    public static @NonNull SdmxCsvFieldWriter onTimeDimension(@NonNull String label, @NonNull Formatter<LocalDateTime> formatter) {
        Objects.requireNonNull(formatter);
        return SdmxCsvFieldWriter.single(label, (series, obs) -> formatter.format((Object)obs.getPeriod()));
    }

    public static @NonNull SdmxCsvFieldWriter onObsValue(@NonNull String label, @NonNull Formatter<Number> formatter) {
        Objects.requireNonNull(formatter);
        return SdmxCsvFieldWriter.single(label, (series, obs) -> formatter.format((Object)obs.getValue()));
    }

    public static @NonNull SdmxCsvFieldWriter onAttributes(@NonNull DataStructure dsd) {
        return SdmxCsvFieldWriter.onAttributes(dsd.getAttributes().stream().sorted(Comparator.comparing(Attribute::getId)).map(Attribute::getId).collect(Collectors.toList()));
    }

    public static @NonNull SdmxCsvFieldWriter onAttributes(@NonNull List<String> labels) {
        return SdmxCsvFieldWriter.multi(labels, (series, obs, i) -> {
            String label = (String)labels.get(i);
            String value = (String)series.getMeta().get(label);
            return value != null ? value : (CharSequence)obs.getMeta().get(label);
        });
    }

    public static @NonNull SdmxCsvFieldWriter onCompactObsAttributes(@NonNull String label, @NonNull Formatter<Map<String, String>> formatter) {
        Objects.requireNonNull(formatter);
        return SdmxCsvFieldWriter.single(label, (series, obs) -> formatter.format((Object)obs.getMeta()));
    }

    public static @NonNull SdmxCsvFieldWriter onSeriesKey(@NonNull String label) {
        return SdmxCsvFieldWriter.single(label, (series, obs) -> series.getKey().toString());
    }

    public static @NonNull SdmxCsvFieldWriter onConstant(@NonNull String label, @NonNull String value) {
        Objects.requireNonNull(value);
        return SdmxCsvFieldWriter.single(label, (series, obs) -> value);
    }

    @FunctionalInterface
    public static interface MultiField {
        public @NonNull CharSequence apply(@NonNull Series var1, @NonNull Obs var2, int var3);
    }

    @FunctionalInterface
    public static interface SingleField {
        public @Nullable CharSequence apply(@NonNull Series var1, @NonNull Obs var2);
    }
}

