/*
 * Decompiled with CFR 0.152.
 */
package sdmxdl.format.csv;

import java.io.IOException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import nbbrd.io.picocsv.Picocsv;
import nbbrd.io.text.Parser;
import nbbrd.picocsv.Csv;
import sdmxdl.Attribute;
import sdmxdl.DataSet;
import sdmxdl.Duration;
import sdmxdl.FlowRef;
import sdmxdl.Key;
import sdmxdl.Obs;
import sdmxdl.Query;
import sdmxdl.Series;
import sdmxdl.Structure;
import sdmxdl.TimeInterval;
import sdmxdl.format.ObsParser;
import sdmxdl.format.csv.SdmxCsvFields;
import sdmxdl.format.time.ObservationalTimePeriod;

public final class SdmxPicocsvParser {
    @NonNull
    private final Supplier<ObsParser> factory;
    @NonNull
    private final Locale locale;

    public // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull Picocsv.Parser<DataSet> getParser(Structure dsd) {
        return Picocsv.Parser.builder(reader -> this.parseCsv(dsd, reader)).build();
    }

    private DataSet parseCsv(Structure dsd, Csv.Reader reader) throws IOException {
        List<String> header = this.readHeader(reader);
        int minHeaderSize = 3 + dsd.getDimensions().size();
        if (header.size() < minHeaderSize) {
            throw new IOException("Invalid header size");
        }
        if (!"DATAFLOW".equals(header.get(0))) {
            throw new IOException("Invalid dataflow header");
        }
        if (!dsd.getTimeDimensionId().equals(header.get(1 + dsd.getDimensions().size()))) {
            throw new IOException("Invalid time dimension header");
        }
        if (!"OBS_VALUE".equals(header.get(1 + dsd.getDimensions().size() + 1))) {
            throw new IOException("Invalid obs value header");
        }
        int seriesKeyIndex = header.subList(minHeaderSize, header.size()).indexOf("SERIESKEY");
        if (seriesKeyIndex != -1) {
            Map attributes = dsd.getAttributes().stream().collect(Collectors.toMap(Attribute::getId, Function.identity()));
            for (int i = minHeaderSize; i < seriesKeyIndex; ++i) {
                String attributeId = header.get(i);
                if (attributes.containsKey(attributeId)) continue;
                throw new IOException("Unknown attribute header");
            }
        }
        ObsParser obsParser = this.factory.get();
        Parser<FlowRef> refParser = SdmxCsvFields.getDataflowRefParser();
        FlowRef flowRef = FlowRef.of(null, (String)"", null);
        HashMap<Key, Series.Builder> data = new HashMap<Key, Series.Builder>();
        Key.Builder keyBuilder = Key.builder((Structure)dsd);
        Obs.Builder obs = Obs.builder();
        while (SdmxPicocsvParser.skipComments(reader)) {
            Double nullableValue;
            if (!reader.readField()) {
                throw new IOException("Missing dataflow field");
            }
            flowRef = (FlowRef)refParser.parse((CharSequence)reader);
            keyBuilder.clear();
            for (int i = 0; i < keyBuilder.size(); ++i) {
                if (!reader.readField()) {
                    throw new IOException("Missing dimension field");
                }
                keyBuilder.put(header.get(1 + i), reader.toString());
            }
            if (!reader.readField()) {
                throw new IOException("Missing time dimension field");
            }
            obsParser.period(reader.toString());
            if (!reader.readField()) {
                throw new IOException("Missing obs value field");
            }
            obsParser.value(reader.toString());
            Series.Builder series = data.computeIfAbsent(keyBuilder.build(), z -> Series.builder().key(z));
            ObservationalTimePeriod observationalTimePeriod = obsParser.parsePeriod();
            TimeInterval nullablePeriod = observationalTimePeriod != null ? TimeInterval.of((LocalDateTime)observationalTimePeriod.toStartTime(null), (Duration)observationalTimePeriod.getDuration()) : null;
            if (nullablePeriod == null || (nullableValue = obsParser.parseValue()) == null) continue;
            series.obs(obs.clearMeta().period(nullablePeriod).value(nullableValue.doubleValue()).build());
        }
        return (DataSet)data.values().stream().map(Series.Builder::build).collect(DataSet.toDataSet((FlowRef)flowRef, (Query)Query.ALL));
    }

    private List<String> readHeader(Csv.Reader reader) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        if (!SdmxPicocsvParser.skipComments(reader)) {
            throw new IOException("Missing header");
        }
        while (reader.readField()) {
            result.add(reader.toString());
        }
        return result;
    }

    private static boolean skipComments(Csv.Reader reader) throws IOException {
        while (reader.readLine()) {
            if (reader.isComment()) continue;
            return true;
        }
        return false;
    }

    @Generated
    private static Locale $default$locale() {
        return Locale.ROOT;
    }

    @Generated
    SdmxPicocsvParser(@NonNull Supplier<ObsParser> factory, @NonNull Locale locale) {
        if (factory == null) {
            throw new NullPointerException("factory is marked non-null but is null");
        }
        if (locale == null) {
            throw new NullPointerException("locale is marked non-null but is null");
        }
        this.factory = factory;
        this.locale = locale;
    }

    @Generated
    public static @org.checkerframework.checker.nullness.qual.NonNull Builder builder() {
        return new Builder();
    }

    @Generated
    public @org.checkerframework.checker.nullness.qual.NonNull Builder toBuilder() {
        return new Builder().factory(this.factory).locale(this.locale);
    }

    @Generated
    public static class Builder {
        @Generated
        private Supplier<ObsParser> factory;
        @Generated
        private boolean locale$set;
        @Generated
        private Locale locale$value;

        @Generated
        Builder() {
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull Builder factory(@NonNull Supplier<ObsParser> factory) {
            if (factory == null) {
                throw new NullPointerException("factory is marked non-null but is null");
            }
            this.factory = factory;
            return this;
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull Builder locale(@NonNull Locale locale) {
            if (locale == null) {
                throw new NullPointerException("locale is marked non-null but is null");
            }
            this.locale$value = locale;
            this.locale$set = true;
            return this;
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull SdmxPicocsvParser build() {
            Locale locale$value = this.locale$value;
            if (!this.locale$set) {
                locale$value = SdmxPicocsvParser.$default$locale();
            }
            return new SdmxPicocsvParser(this.factory, locale$value);
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull String toString() {
            return "SdmxPicocsvParser.Builder(factory=" + this.factory + ", locale$value=" + this.locale$value + ")";
        }
    }
}

