/*
 * Decompiled with CFR 0.152.
 */
package sdmxdl.format.csv;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Locale;
import lombok.Generated;
import lombok.NonNull;
import nbbrd.io.text.Formatter;
import nbbrd.io.text.Parser;
import sdmxdl.FlowRef;
import sdmxdl.Series;

public final class SdmxCsvFields {
    public static final String DATAFLOW = "DATAFLOW";
    public static final String KEY_DIMENSIONS = "KEY_DIMENSIONS";
    public static final String TIME_DIMENSION = "TIME_DIMENSION";
    public static final String OBS_VALUE = "OBS_VALUE";
    public static final String ATTRIBUTES = "ATTRIBUTES";
    public static final String SERIESKEY = "SERIESKEY";

    @NonNull
    public static Formatter<FlowRef> getDataflowRefFormatter() {
        return SdmxCsvFields::formatDataflowField;
    }

    @NonNull
    public static Parser<FlowRef> getDataflowRefParser() {
        return SdmxCsvFields::parseDataflowField;
    }

    @NonNull
    public static Formatter<Number> getValueFormatter(@NonNull Locale locale) {
        if (locale == null) {
            throw new NullPointerException("locale is marked non-null but is null");
        }
        return Formatter.onNumberFormat((NumberFormat)SdmxCsvFields.getNumberFormat(locale));
    }

    @NonNull
    public static Formatter<LocalDateTime> getPeriodFormatter(@NonNull Collection<Series> data) {
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        return Formatter.onDateTimeFormatter((DateTimeFormatter)SdmxCsvFields.getDateTimeFormatter());
    }

    private static NumberFormat getNumberFormat(Locale encoding) {
        DecimalFormat decimalFormat = new DecimalFormat("", DecimalFormatSymbols.getInstance(encoding));
        decimalFormat.setGroupingUsed(false);
        return decimalFormat;
    }

    private static DateTimeFormatter getDateTimeFormatter() {
        return DateTimeFormatter.ISO_DATE_TIME;
    }

    private static String formatDataflowField(FlowRef ref) {
        return ref != null ? ref.getAgency() + ":" + ref.getId() + "(" + ref.getVersion() + ")" : null;
    }

    private static FlowRef parseDataflowField(CharSequence ref) {
        if (ref == null) {
            return null;
        }
        String text = ref.toString();
        int idx1 = text.indexOf(58);
        if (idx1 == -1) {
            return null;
        }
        int idx2 = text.indexOf(40, idx1);
        if (idx2 == -1) {
            return null;
        }
        int idx3 = text.indexOf(41, idx2);
        if (idx3 == -1) {
            return null;
        }
        if (idx3 != text.length() - 1) {
            return null;
        }
        return FlowRef.of((String)text.substring(0, idx1), (String)text.substring(idx1 + 1, idx2), (String)text.substring(idx2 + 1, idx3));
    }

    @Generated
    private SdmxCsvFields() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

