/*
 * Decompiled with CFR 0.152.
 */
package sdmxdl.format.csv;

import java.io.IOException;
import java.time.LocalDateTime;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.NonNull;
import nbbrd.io.function.IOConsumer;
import nbbrd.io.text.Formatter;
import org.checkerframework.checker.nullness.qual.Nullable;
import sdmxdl.Attribute;
import sdmxdl.Dimension;
import sdmxdl.FlowRef;
import sdmxdl.Obs;
import sdmxdl.Series;
import sdmxdl.Structure;
import sdmxdl.format.csv.SdmxCsvFields;

public interface SdmxCsvFieldWriter {
    public void writeHead(@NonNull IOConsumer<CharSequence> var1) throws IOException;

    public void writeBody(@NonNull Series var1, @NonNull Obs var2, @NonNull IOConsumer<CharSequence> var3) throws IOException;

    @NonNull
    public static SdmxCsvFieldWriter single(final @NonNull String label, final @NonNull SingleField value) {
        if (label == null) {
            throw new NullPointerException("label is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        return new SdmxCsvFieldWriter(){

            @Override
            public void writeHead(IOConsumer<CharSequence> output) throws IOException {
                output.acceptWithIO((Object)label);
            }

            @Override
            public void writeBody(Series series, Obs obs, IOConsumer<CharSequence> output) throws IOException {
                output.acceptWithIO((Object)value.apply(series, obs));
            }
        };
    }

    @NonNull
    public static SdmxCsvFieldWriter multi(final @NonNull List<String> labels, final @NonNull MultiField values) {
        if (labels == null) {
            throw new NullPointerException("labels is marked non-null but is null");
        }
        if (values == null) {
            throw new NullPointerException("values is marked non-null but is null");
        }
        return new SdmxCsvFieldWriter(){

            @Override
            public void writeHead(IOConsumer<CharSequence> output) throws IOException {
                for (String label : labels) {
                    output.acceptWithIO((Object)label);
                }
            }

            @Override
            public void writeBody(Series series, Obs obs, IOConsumer<CharSequence> output) throws IOException {
                for (int i = 0; i < labels.size(); ++i) {
                    output.acceptWithIO((Object)values.apply(series, obs, i));
                }
            }
        };
    }

    @NonNull
    public static SdmxCsvFieldWriter onDataflow(@NonNull String label, @NonNull FlowRef ref) {
        if (label == null) {
            throw new NullPointerException("label is marked non-null but is null");
        }
        if (ref == null) {
            throw new NullPointerException("ref is marked non-null but is null");
        }
        String dataflow = SdmxCsvFields.getDataflowRefFormatter().formatAsString((Object)ref);
        return SdmxCsvFieldWriter.single(label, (series, obs) -> dataflow);
    }

    @NonNull
    public static SdmxCsvFieldWriter onKeyDimensions(@NonNull Structure dsd) {
        if (dsd == null) {
            throw new NullPointerException("dsd is marked non-null but is null");
        }
        return SdmxCsvFieldWriter.onKeyDimensions(dsd.getDimensions().stream().map(Dimension::getId).collect(Collectors.toList()));
    }

    @NonNull
    public static SdmxCsvFieldWriter onKeyDimensions(@NonNull List<String> labels) {
        if (labels == null) {
            throw new NullPointerException("labels is marked non-null but is null");
        }
        return SdmxCsvFieldWriter.multi(labels, (series, obs, i) -> series.getKey().get(i));
    }

    @NonNull
    public static SdmxCsvFieldWriter onTimeDimension(@NonNull Structure dsd, @NonNull Formatter<LocalDateTime> formatter) {
        if (dsd == null) {
            throw new NullPointerException("dsd is marked non-null but is null");
        }
        if (formatter == null) {
            throw new NullPointerException("formatter is marked non-null but is null");
        }
        return SdmxCsvFieldWriter.onTimeDimension(dsd.getTimeDimensionId(), formatter);
    }

    @NonNull
    public static SdmxCsvFieldWriter onTimeDimension(@NonNull String label, @NonNull Formatter<LocalDateTime> formatter) {
        if (label == null) {
            throw new NullPointerException("label is marked non-null but is null");
        }
        if (formatter == null) {
            throw new NullPointerException("formatter is marked non-null but is null");
        }
        return SdmxCsvFieldWriter.single(label, (series, obs) -> formatter.format((Object)obs.getPeriod().getStart()));
    }

    @NonNull
    public static SdmxCsvFieldWriter onObsValue(@NonNull String label, @NonNull Formatter<Number> formatter) {
        if (label == null) {
            throw new NullPointerException("label is marked non-null but is null");
        }
        if (formatter == null) {
            throw new NullPointerException("formatter is marked non-null but is null");
        }
        return SdmxCsvFieldWriter.single(label, (series, obs) -> formatter.format((Object)obs.getValue()));
    }

    @NonNull
    public static SdmxCsvFieldWriter onAttributes(@NonNull Structure dsd) {
        if (dsd == null) {
            throw new NullPointerException("dsd is marked non-null but is null");
        }
        return SdmxCsvFieldWriter.onAttributes(dsd.getAttributes().stream().sorted(Comparator.comparing(Attribute::getId)).map(Attribute::getId).collect(Collectors.toList()));
    }

    @NonNull
    public static SdmxCsvFieldWriter onAttributes(@NonNull List<String> labels) {
        if (labels == null) {
            throw new NullPointerException("labels is marked non-null but is null");
        }
        return SdmxCsvFieldWriter.multi(labels, (series, obs, i) -> {
            String label = (String)labels.get(i);
            String value = (String)series.getMeta().get(label);
            return value != null ? value : (CharSequence)obs.getMeta().get(label);
        });
    }

    @NonNull
    public static SdmxCsvFieldWriter onCompactObsAttributes(@NonNull String label, @NonNull Formatter<Map<String, String>> formatter) {
        if (label == null) {
            throw new NullPointerException("label is marked non-null but is null");
        }
        if (formatter == null) {
            throw new NullPointerException("formatter is marked non-null but is null");
        }
        return SdmxCsvFieldWriter.single(label, (series, obs) -> formatter.format((Object)obs.getMeta()));
    }

    @NonNull
    public static SdmxCsvFieldWriter onSeriesKey(@NonNull String label) {
        if (label == null) {
            throw new NullPointerException("label is marked non-null but is null");
        }
        return SdmxCsvFieldWriter.single(label, (series, obs) -> series.getKey().toString());
    }

    @NonNull
    public static SdmxCsvFieldWriter onConstant(@NonNull String label, @NonNull String value) {
        if (label == null) {
            throw new NullPointerException("label is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        return SdmxCsvFieldWriter.single(label, (series, obs) -> value);
    }

    @FunctionalInterface
    public static interface SingleField {
        public @Nullable CharSequence apply(@NonNull Series var1, @NonNull Obs var2);
    }

    @FunctionalInterface
    public static interface MultiField {
        @NonNull
        public CharSequence apply(@NonNull Series var1, @NonNull Obs var2, int var3);
    }
}

