package sasquatch.tck;

import java.util.Collections;
import java.util.List;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

/**
 * Custom service loader for {@link sasquatch.tck.SasFeatureAssertion}.
 * <br>This class is thread-safe.
 * <p>Properties:
 * <ul>
 * <li>Quantifier: MULTIPLE</li>
 * <li>Fallback: null</li>
 * <li>Preprocessing: null</li>
 * <li>Mutability: NONE</li>
 * <li>Singleton: true</li>
 * <li>Name: null</li>
 * </ul>
 */
public final class SasFeatureAssertionLoader {
  private static final ServiceLoader<SasFeatureAssertion> SOURCE = ServiceLoader.load(SasFeatureAssertion.class);

  private static final List<SasFeatureAssertion> RESOURCE = doLoad();

  private SasFeatureAssertionLoader() {
  }

  private static List<SasFeatureAssertion> doLoad() {
    return StreamSupport.stream(SOURCE.spliterator(), false)
        .collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
  }

  /**
   * Gets a list of {@link sasquatch.tck.SasFeatureAssertion} instances.
   * <br>This method is thread-safe.
   * @return the current non-null value
   */
  public static List<SasFeatureAssertion> get() {
    return RESOURCE;
  }
}
