package sasquatch.samples;

import java.util.Collections;
import java.util.List;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

/**
 * Custom service loader for {@link sasquatch.samples.SasContent}.
 * <br>This class is thread-safe.
 * <p>Properties:
 * <ul>
 * <li>Quantifier: MULTIPLE</li>
 * <li>Fallback: null</li>
 * <li>Preprocessing: null</li>
 * <li>Mutability: NONE</li>
 * <li>Singleton: true</li>
 * <li>Name: null</li>
 * </ul>
 */
public final class SasContentLoader {
  private static final ServiceLoader<SasContent> SOURCE = ServiceLoader.load(SasContent.class);

  private static final List<SasContent> RESOURCE = doLoad();

  private SasContentLoader() {
  }

  private static List<SasContent> doLoad() {
    return StreamSupport.stream(SOURCE.spliterator(), false)
        .collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
  }

  /**
   * Gets a list of {@link sasquatch.samples.SasContent} instances.
   * <br>This method is thread-safe.
   * @return the current non-null value
   */
  public static List<SasContent> get() {
    return RESOURCE;
  }
}
