/*
 * Decompiled with CFR 0.152.
 */
package sasquatch.ri;

import internal.ri.data.Document;
import java.io.IOException;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.EnumSet;
import java.util.Set;
import sasquatch.SasForwardCursor;
import sasquatch.SasMetaData;
import sasquatch.SasScrollableCursor;
import sasquatch.SasSplittableCursor;
import sasquatch.ri.DocumentUtil;
import sasquatch.ri.SasquatchCursor;
import sasquatch.spi.SasFeature;
import sasquatch.spi.SasReader;
import sasquatch.util.SasCursors;

public final class SasquatchReader
implements SasReader {
    public static final String NAME = "RI";

    public String getName() {
        return NAME;
    }

    public boolean isAvailable() {
        return true;
    }

    public int getCost() {
        return 100;
    }

    public Set<SasFeature> getFeatures() {
        return EnumSet.of(SasFeature.ATTRIBUTES, new SasFeature[]{SasFeature.LABEL_META, SasFeature.BIG_ENDIAN_32, SasFeature.LITTLE_ENDIAN_32, SasFeature.BIG_ENDIAN_64, SasFeature.LITTLE_ENDIAN_64, SasFeature.CHAR_COMP, SasFeature.BIN_COMP, SasFeature.DATE_TYPE, SasFeature.DATE_TIME_TYPE, SasFeature.TIME_TYPE, SasFeature.FIELD_ENCODING, SasFeature.COLUMN_ENCODING, SasFeature.CUSTOM_NUMERIC, SasFeature.COLUMN_FORMAT});
    }

    public SasForwardCursor readForward(Path file) throws IOException {
        SeekableByteChannel sbc = Files.newByteChannel(file, StandardOpenOption.READ);
        try {
            return SasquatchCursor.of(sbc);
        }
        catch (Error | RuntimeException e) {
            try {
                sbc.close();
            }
            catch (IOException ex) {
                try {
                    e.addSuppressed(ex);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            throw e;
        }
    }

    public SasScrollableCursor readScrollable(Path file) throws IOException {
        return SasCursors.asScrollable((SasForwardCursor)this.readForward(file));
    }

    public SasSplittableCursor readSplittable(Path file) throws IOException {
        return SasCursors.asSplittable((SasForwardCursor)this.readForward(file));
    }

    public SasMetaData readMetaData(Path file) throws IOException {
        return DocumentUtil.getMetaData(Document.parse(file));
    }
}

