/*
 * Decompiled with CFR 0.152.
 */
package sasquatch.ri;

import internal.ri.data.Document;
import internal.ri.data.rows.RowCursor;
import internal.ri.data.rows.ValueReader;
import java.io.IOException;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.Charset;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.List;
import sasquatch.SasColumn;
import sasquatch.SasForwardCursor;
import sasquatch.SasMetaData;
import sasquatch.ri.DocumentUtil;

final class SasquatchCursor
implements SasForwardCursor {
    private final SasMetaData metaData;
    private final RowCursor rowCursor;
    private final ValueReader[] readers;
    private final SeekableByteChannel resource;

    static SasquatchCursor of(SeekableByteChannel sbc) throws IOException {
        Document doc = Document.parse(sbc);
        SasMetaData metaData = DocumentUtil.getMetaData(doc);
        RowCursor rowCursor = RowCursor.of(sbc, doc);
        ValueReader[] readers = SasquatchCursor.createReaders(metaData.getColumns(), DocumentUtil.getOffsets(doc), DocumentUtil.getCharset(doc));
        return new SasquatchCursor(metaData, rowCursor, readers, sbc);
    }

    public SasMetaData getMetaData() {
        return this.metaData;
    }

    public boolean next() throws IOException {
        return this.rowCursor.next();
    }

    public Object getValue(int columnIndex) throws IOException, IndexOutOfBoundsException {
        return this.readers[columnIndex].read(this.rowCursor.getBytes());
    }

    public double getNumber(int columnIndex) throws IOException {
        try {
            return ((ValueReader.NumberReader)this.readers[columnIndex]).readDouble(this.rowCursor.getBytes());
        }
        catch (ClassCastException ex) {
            throw this.invalidColumnType(columnIndex, ValueReader.NumberReader.class, ex);
        }
    }

    public String getString(int columnIndex) throws IOException {
        try {
            return (String)((ValueReader.StringReader)this.readers[columnIndex]).read(this.rowCursor.getBytes());
        }
        catch (ClassCastException ex) {
            throw this.invalidColumnType(columnIndex, ValueReader.StringReader.class, ex);
        }
    }

    public LocalDate getDate(int columnIndex) throws IOException {
        try {
            return (LocalDate)((ValueReader.DateReader)this.readers[columnIndex]).read(this.rowCursor.getBytes());
        }
        catch (ClassCastException ex) {
            throw this.invalidColumnType(columnIndex, ValueReader.DateReader.class, ex);
        }
    }

    public LocalDateTime getDateTime(int columnIndex) throws IOException {
        try {
            return (LocalDateTime)((ValueReader.DateTimeReader)this.readers[columnIndex]).read(this.rowCursor.getBytes());
        }
        catch (ClassCastException ex) {
            throw this.invalidColumnType(columnIndex, ValueReader.DateTimeReader.class, ex);
        }
    }

    public LocalTime getTime(int columnIndex) throws IOException {
        try {
            return (LocalTime)((ValueReader.TimeReader)this.readers[columnIndex]).read(this.rowCursor.getBytes());
        }
        catch (ClassCastException ex) {
            throw this.invalidColumnType(columnIndex, ValueReader.TimeReader.class, ex);
        }
    }

    public Object[] getValues() throws IOException {
        Object[] result = new Object[this.readers.length];
        for (int j = 0; j < result.length; ++j) {
            result[j] = this.getValue(j);
        }
        return result;
    }

    public void close() throws IOException {
        this.resource.close();
    }

    private IllegalArgumentException invalidColumnType(int columnIndex, Class<? extends ValueReader> expected, ClassCastException ex) {
        Class<?> actual = this.readers[columnIndex].getClass();
        return new IllegalArgumentException("Column at index " + columnIndex + " expected to be '" + SasquatchCursor.getName(expected) + "' but was '" + SasquatchCursor.getName(actual) + "' instead");
    }

    private static String getName(Class<? extends ValueReader> reader) {
        if (ValueReader.NumberReader.class.isAssignableFrom(reader)) {
            return "Number";
        }
        if (ValueReader.StringReader.class.isAssignableFrom(reader)) {
            return "String";
        }
        if (ValueReader.DateReader.class.isAssignableFrom(reader)) {
            return "Date";
        }
        if (ValueReader.DateTimeReader.class.isAssignableFrom(reader)) {
            return "DateTime";
        }
        if (ValueReader.TimeReader.class.isAssignableFrom(reader)) {
            return "Time";
        }
        throw new RuntimeException("Unknown column type");
    }

    private static ValueReader[] createReaders(List<SasColumn> columns, int[] offsets, Charset charset) {
        ValueReader[] result = new ValueReader[columns.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = SasquatchCursor.createReader(columns.get(i), offsets[i], charset);
        }
        return result;
    }

    private static ValueReader createReader(SasColumn c, int offset, Charset charset) {
        switch (c.getType()) {
            case CHARACTER: {
                return ValueReader.stringReader(offset, c.getLength(), charset);
            }
            case NUMERIC: {
                return ValueReader.numberReader(offset, c.getLength());
            }
            case DATE: {
                return ValueReader.dateReader(ValueReader.numberReader(offset, c.getLength()));
            }
            case DATETIME: {
                return ValueReader.dateTimeReader(ValueReader.numberReader(offset, c.getLength()));
            }
            case TIME: {
                return ValueReader.timeReader(ValueReader.numberReader(offset, c.getLength()));
            }
        }
        throw new RuntimeException("Unknown column type");
    }

    private SasquatchCursor(SasMetaData metaData, RowCursor rowCursor, ValueReader[] readers, SeekableByteChannel resource) {
        this.metaData = metaData;
        this.rowCursor = rowCursor;
        this.readers = readers;
        this.resource = resource;
    }
}

