/*
 * Decompiled with CFR 0.152.
 */
package internal.ri.data.rows;

import internal.bytes.BytesReader;
import internal.ri.base.SasCalendar;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface ValueReader<T> {
    public @Nullable T read(@NonNull BytesReader var1);

    public static @NonNull NumberReader numberReader(int offset, int length) {
        switch (length) {
            case 8: {
                return bytes -> bytes.getFloat64(offset);
            }
        }
        return new CustomNumericReader(offset, length);
    }

    public static @NonNull StringReader stringReader(int offset, int length, @NonNull Charset charset) {
        return new DecoderStringReader(offset, length, charset);
    }

    public static @NonNull DateReader dateReader(@NonNull NumberReader reader) {
        return bytes -> SasCalendar.getDate(reader.readDouble(bytes));
    }

    public static @NonNull DateTimeReader dateTimeReader(@NonNull NumberReader reader) {
        return bytes -> SasCalendar.getDateTime(reader.readDouble(bytes));
    }

    public static @NonNull TimeReader timeReader(@NonNull NumberReader reader) {
        return bytes -> SasCalendar.getTime(reader.readDouble(bytes));
    }

    public static final class CustomNumericReader
    implements NumberReader {
        private final int offset;
        private final int start;
        private final ByteBuffer tmp;

        private CustomNumericReader(int offset, int length) {
            this.offset = offset;
            this.start = 8 - length;
            this.tmp = ByteBuffer.wrap(new byte[8]);
        }

        @Override
        public double readDouble(BytesReader bytes) {
            for (int i = this.start; i < 8; ++i) {
                this.tmp.put(i, bytes.getByte(this.offset + i - this.start));
            }
            return this.tmp.order(bytes.getOrder()).getDouble(0);
        }
    }

    public static final class DefaultStringReader
    implements StringReader {
        private final int offset;
        private final byte[] buffer;
        private final Charset charset;

        private DefaultStringReader(int offset, int length, Charset charset) {
            this.offset = offset;
            this.buffer = new byte[length];
            this.charset = charset;
        }

        @Override
        public String read(BytesReader bytes) {
            bytes.copyTo(this.offset, this.buffer, 0, this.buffer.length);
            return new String(this.buffer, this.charset).trim();
        }
    }

    public static final class DecoderStringReader
    implements StringReader {
        private final int offset;
        private final int length;
        private final CharsetDecoder decoder;

        private DecoderStringReader(int offset, int length, Charset charset) {
            this.offset = offset;
            this.length = length;
            this.decoder = charset.newDecoder();
            this.decoder.onMalformedInput(CodingErrorAction.IGNORE);
        }

        @Override
        public String read(BytesReader bytes) {
            try {
                String result = bytes.decode(this.offset, this.length, this.decoder).toString().trim();
                return result.isEmpty() ? null : result;
            }
            catch (CharacterCodingException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public static interface TimeReader
    extends ValueReader<LocalTime> {
    }

    public static interface DateTimeReader
    extends ValueReader<LocalDateTime> {
    }

    public static interface DateReader
    extends ValueReader<LocalDate> {
    }

    public static interface StringReader
    extends ValueReader<String> {
    }

    public static interface NumberReader
    extends ValueReader<Double> {
        @Override
        default public Double read(BytesReader bytes) {
            return this.readDouble(bytes);
        }

        public double readDouble(@NonNull BytesReader var1);
    }
}

