/*
 * Decompiled with CFR 0.152.
 */
package internal.ri.data.rows;

import internal.bytes.BytesCursor;
import internal.ri.data.Document;
import internal.ri.data.rows.CompressedForwardingCursor;
import internal.ri.data.rows.PackedBinaryForwardingCursor;
import internal.ri.data.rows.RDCDecompressor;
import internal.ri.data.rows.RLEDecompressor;
import java.io.IOException;
import java.nio.channels.SeekableByteChannel;
import org.checkerframework.checker.nullness.qual.NonNull;

public interface RowCursor
extends BytesCursor {
    public static @NonNull RowCursor of(@NonNull SeekableByteChannel sbc, @NonNull Document doc) throws IOException {
        if (doc.getCompression().isKnown()) {
            switch (doc.getCompression().get()) {
                case CHAR: {
                    return CompressedForwardingCursor.of(sbc, doc.getHeader(), doc.getRowSize(), RLEDecompressor.INSTANCE);
                }
                case BIN: {
                    return CompressedForwardingCursor.of(sbc, doc.getHeader(), doc.getRowSize(), RDCDecompressor.INSTANCE);
                }
                case NONE: {
                    return PackedBinaryForwardingCursor.of(sbc, doc.getHeader(), doc.getRowSize());
                }
            }
        }
        throw new IOException("Cannot handle compression " + doc.getCompression().toString());
    }
}

