/*
 * Decompiled with CFR 0.152.
 */
package internal.ri.data.rows;

import internal.bytes.Bytes;
import internal.bytes.BytesReader;
import internal.ri.data.rows.AbstractDecompressor;

final class RLEDecompressor
extends AbstractDecompressor {
    public static final RLEDecompressor INSTANCE = new RLEDecompressor();
    static final byte COPY_64_LONG = 0;
    static final byte INSERT_BYTE_LONG = 4;
    static final byte INSERT_AT_LONG = 5;
    static final byte INSERT_BLANK_LONG = 6;
    static final byte INSERT_ZERO_LONG = 7;
    static final byte COPY_1_SHORT = 8;
    static final byte COPY_17_SHORT = 9;
    static final byte COPY_33_SHORT = 10;
    static final byte COPY_49_SHORT = 11;
    static final byte INSERT_BYTE_SHORT = 12;
    static final byte INSERT_AT_SHORT = 13;
    static final byte INSERT_BLANK_SHORT = 14;
    static final byte INSERT_ZERO_SHORT = 15;
    static final byte ZERO = 0;
    static final byte BLANK = 32;
    static final byte AT = 64;

    RLEDecompressor() {
    }

    @Override
    public void uncompress(BytesReader src, int position, Bytes dst, int length) {
        int srcPos = position;
        int dstPos = 0;
        block15: while (srcPos < position + length) {
            int firstByteIdx = srcPos++;
            switch (src.getHigh(firstByteIdx)) {
                case 0: {
                    int size = 64 + RLEDecompressor.uint8(src.getByte(srcPos++));
                    RLEDecompressor.copy(src, srcPos, dst, dstPos, size);
                    srcPos += size;
                    dstPos += size;
                    continue block15;
                }
                case 4: {
                    int size = 18 + RLEDecompressor.uint8(src.getByte(srcPos++));
                    byte value = src.getByte(srcPos++);
                    RLEDecompressor.insert(dst, dstPos, size, value);
                    dstPos += size;
                    continue block15;
                }
                case 5: {
                    int size = 17 + RLEDecompressor.uint8(src.getByte(srcPos++));
                    RLEDecompressor.insert(dst, dstPos, size, (byte)64);
                    dstPos += size;
                    continue block15;
                }
                case 6: {
                    int size = 17 + RLEDecompressor.uint8(src.getByte(srcPos++));
                    RLEDecompressor.insert(dst, dstPos, size, (byte)32);
                    dstPos += size;
                    continue block15;
                }
                case 7: {
                    int size = 17 + RLEDecompressor.uint8(src.getByte(srcPos++));
                    RLEDecompressor.insert(dst, dstPos, size, (byte)0);
                    dstPos += size;
                    continue block15;
                }
                case 8: {
                    int size = 1 + RLEDecompressor.uint4(src.getLow(firstByteIdx));
                    RLEDecompressor.copy(src, srcPos, dst, dstPos, size);
                    srcPos += size;
                    dstPos += size;
                    continue block15;
                }
                case 9: {
                    int size = 17 + RLEDecompressor.uint4(src.getLow(firstByteIdx));
                    RLEDecompressor.copy(src, srcPos, dst, dstPos, size);
                    srcPos += size;
                    dstPos += size;
                    continue block15;
                }
                case 10: {
                    int size = 33 + RLEDecompressor.uint4(src.getLow(firstByteIdx));
                    RLEDecompressor.copy(src, srcPos, dst, dstPos, size);
                    srcPos += size;
                    dstPos += size;
                    continue block15;
                }
                case 11: {
                    int size = 49 + RLEDecompressor.uint4(src.getLow(firstByteIdx));
                    RLEDecompressor.copy(src, srcPos, dst, dstPos, size);
                    srcPos += size;
                    dstPos += size;
                    continue block15;
                }
                case 12: {
                    int size = 3 + RLEDecompressor.uint4(src.getLow(firstByteIdx));
                    byte value = src.getByte(srcPos++);
                    RLEDecompressor.insert(dst, dstPos, size, value);
                    dstPos += size;
                    continue block15;
                }
                case 13: {
                    int size = 2 + RLEDecompressor.uint4(src.getLow(firstByteIdx));
                    RLEDecompressor.insert(dst, dstPos, size, (byte)64);
                    dstPos += size;
                    continue block15;
                }
                case 14: {
                    int size = 2 + RLEDecompressor.uint4(src.getLow(firstByteIdx));
                    RLEDecompressor.insert(dst, dstPos, size, (byte)32);
                    dstPos += size;
                    continue block15;
                }
                case 15: {
                    int size = 2 + RLEDecompressor.uint4(src.getLow(firstByteIdx));
                    RLEDecompressor.insert(dst, dstPos, size, (byte)0);
                    dstPos += size;
                    continue block15;
                }
            }
            throw new RuntimeException("Unknown control byte: " + src.getHigh(firstByteIdx));
        }
    }
}

