/*
 * Decompiled with CFR 0.152.
 */
package internal.ri.data.rows;

import internal.bytes.Bytes;
import internal.bytes.BytesReader;
import internal.ri.data.rows.AbstractDecompressor;

final class RDCDecompressor
extends AbstractDecompressor {
    public static final RDCDecompressor INSTANCE = new RDCDecompressor();

    RDCDecompressor() {
    }

    @Override
    public void uncompress(BytesReader src, int position, Bytes dst, int length) {
        int ctrl_bits = 0;
        int ctrl_mask = 0;
        int srcPos = position;
        int dstPos = 0;
        block5: while (srcPos < position + length) {
            int patternLength;
            int patternOffset;
            if ((ctrl_mask >>= 1) == 0) {
                ctrl_bits = (src.getByte(srcPos) & 0xFF) << 8 | src.getByte(srcPos + 1) & 0xFF;
                srcPos += 2;
                ctrl_mask = 32768;
            }
            if (RDCDecompressor.isUncompressedChar(ctrl_bits, ctrl_mask)) {
                dst.putByte(dstPos++, src.getByte(srcPos++));
                continue;
            }
            int firstByteIndex = srcPos++;
            switch (src.getHigh(firstByteIndex)) {
                case 0: {
                    int repeat = 3 + RDCDecompressor.uint4(src.getLow(firstByteIndex));
                    byte value = src.getByte(srcPos++);
                    RDCDecompressor.insert(dst, dstPos, repeat, value);
                    dstPos += repeat;
                    continue block5;
                }
                case 1: {
                    int repeat = 19 + RDCDecompressor.uint12(src.getLow(firstByteIndex), src.getByte(srcPos++));
                    byte value = src.getByte(srcPos++);
                    RDCDecompressor.insert(dst, dstPos, repeat, value);
                    dstPos += repeat;
                    continue block5;
                }
                case 2: {
                    patternOffset = 3 + RDCDecompressor.uint12(src.getLow(firstByteIndex), src.getByte(srcPos++));
                    patternLength = 16 + RDCDecompressor.uint8(src.getByte(srcPos++));
                    RDCDecompressor.copy(dst, dstPos - patternOffset, dst, dstPos, patternLength);
                    dstPos += patternLength;
                    continue block5;
                }
            }
            patternOffset = 3 + RDCDecompressor.uint12(src.getLow(firstByteIndex), src.getByte(srcPos++));
            patternLength = RDCDecompressor.uint4(src.getHigh(firstByteIndex));
            RDCDecompressor.copy(dst, dstPos - patternOffset, dst, dstPos, patternLength);
            dstPos += patternLength;
        }
    }

    private static boolean isUncompressedChar(int ctrl_bits, int ctrl_mask) {
        return (ctrl_bits & ctrl_mask) == 0;
    }
}

