/*
 * Decompiled with CFR 0.152.
 */
package internal.ri.data.rows;

import internal.bytes.BytesReader;
import internal.bytes.BytesWithOffset;
import internal.ri.base.Header;
import internal.ri.base.PageCursor;
import internal.ri.base.PageHeader;
import internal.ri.base.PageType;
import internal.ri.base.SubHeaderPointer;
import internal.ri.data.RowSize;
import internal.ri.data.rows.ForwardingCursor;
import internal.ri.data.rows.RowCursor;
import java.io.IOException;
import java.nio.channels.SeekableByteChannel;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

final class PackedBinaryForwardingCursor
extends ForwardingCursor {
    @lombok.NonNull
    private final PageCursor pageCursor;
    private final boolean u64;
    private final int count;
    private final @NonNegative int rowLength;
    private final BytesWithOffset bytes;
    private int index;
    private @Nullable PageHeader currentPage;
    private @NonNegative int remainingRowsInCurrentPage;

    public static @NonNull RowCursor of(@NonNull SeekableByteChannel sbc, @NonNull Header header, @NonNull RowSize rowSize) {
        return new PackedBinaryForwardingCursor(PageCursor.of(sbc, header), header.isU64(), rowSize.getCount(), rowSize.getLength(), new BytesWithOffset(), -1, null, 0);
    }

    @Override
    protected boolean hasNextRow() {
        return this.index + 1 < this.count;
    }

    @Override
    protected boolean hasNextRowInCurrentPage() {
        return this.remainingRowsInCurrentPage > 0;
    }

    @Override
    protected void moveToNextRowInCurrentPage() {
        this.bytes.incrementOffset(this.rowLength);
        --this.remainingRowsInCurrentPage;
        ++this.index;
    }

    @Override
    protected void moveToFirstRowInNextPage() throws IOException {
        this.currentPage = PackedBinaryForwardingCursor.nextPageWithData(this.pageCursor, this.u64, PackedBinaryForwardingCursor::hasData);
        this.bytes.reset(this.pageCursor.getBytes(), 0);
        this.setBaseAndRemaining();
        --this.remainingRowsInCurrentPage;
        ++this.index;
    }

    @Override
    protected boolean isDeleted() throws IOException {
        return false;
    }

    private void setBaseAndRemaining() throws IOException {
        switch (this.currentPage.getType().get()) {
            case MIX: {
                this.bytes.incrementOffset(PackedBinaryForwardingCursor.getRowOffsetInMix(this.currentPage, this.u64, this.rowLength, this.pageCursor.getBytes()));
                this.remainingRowsInCurrentPage = PackedBinaryForwardingCursor.getRowCountInMix(this.currentPage);
                break;
            }
            case DATA: {
                this.bytes.incrementOffset(PageHeader.getHeadLength(this.u64));
                this.remainingRowsInCurrentPage = this.currentPage.getDataBlockCount();
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
    }

    private static int getRowCountInMix(PageHeader page) {
        return page.getDataBlockCount() - page.getSubHeaderCount();
    }

    private static int getRowOffsetInMix(PageHeader page, boolean u64, int rowLength, BytesReader pageBytes) {
        int requiredLength = rowLength * PackedBinaryForwardingCursor.getRowCountInMix(page);
        int availableLength = PackedBinaryForwardingCursor.getMinimumSubHeaderOffsetInMix(pageBytes, u64, page);
        int base = PageHeader.getHeadLength(u64);
        int offset = page.getSubHeaderCount() * (u64 ? 24 : 12);
        int align = offset % 8;
        int result = base + offset;
        if (PageHeader.canAlign(requiredLength, availableLength, base, offset, align)) {
            result += align;
        }
        return result;
    }

    private static int getMinimumSubHeaderOffsetInMix(BytesReader pageBytes, boolean u64, PageHeader page) {
        return SubHeaderPointer.parseAll(pageBytes, u64, page).stream().mapToInt(SubHeaderPointer::getOffset).min().orElse(pageBytes.getLength());
    }

    private static boolean hasData(BytesReader pageBytes, PageHeader page, boolean u64) {
        return page.getType().isKnownAs(PageType.MIX) || page.getType().isKnownAs(PageType.DATA);
    }

    private PackedBinaryForwardingCursor(@lombok.NonNull PageCursor pageCursor, boolean u64, int count, @NonNegative int rowLength, BytesWithOffset bytes, int index, @Nullable PageHeader currentPage, @NonNegative int remainingRowsInCurrentPage) {
        if (pageCursor == null) {
            throw new NullPointerException("pageCursor is marked non-null but is null");
        }
        this.pageCursor = pageCursor;
        this.u64 = u64;
        this.count = count;
        this.rowLength = rowLength;
        this.bytes = bytes;
        this.index = index;
        this.currentPage = currentPage;
        this.remainingRowsInCurrentPage = remainingRowsInCurrentPage;
    }

    @Override
    public int getCount() {
        return this.count;
    }

    @Override
    public BytesWithOffset getBytes() {
        return this.bytes;
    }

    @Override
    public int getIndex() {
        return this.index;
    }
}

