/*
 * Decompiled with CFR 0.152.
 */
package internal.ri.data.rows;

import internal.bytes.Bytes;
import internal.bytes.BytesReader;
import internal.ri.base.PageCursor;
import internal.ri.base.PageHeader;
import internal.ri.data.rows.RowCursor;
import java.io.IOException;

abstract class ForwardingCursor
implements RowCursor {
    ForwardingCursor() {
    }

    @Override
    public boolean next() throws IOException {
        do {
            if (this.moveToNextRow()) continue;
            return false;
        } while (this.isDeleted());
        return true;
    }

    private boolean moveToNextRow() throws IOException {
        if (this.hasNextRow()) {
            if (this.hasNextRowInCurrentPage()) {
                this.moveToNextRowInCurrentPage();
            } else {
                this.moveToFirstRowInNextPage();
            }
            return true;
        }
        return false;
    }

    protected abstract boolean hasNextRow() throws IOException;

    protected abstract boolean hasNextRowInCurrentPage() throws IOException;

    protected abstract void moveToNextRowInCurrentPage() throws IOException;

    protected abstract void moveToFirstRowInNextPage() throws IOException;

    protected abstract boolean isDeleted() throws IOException;

    static PageHeader nextPageWithData(PageCursor pageCursor, boolean u64, HasData hasData) throws IOException {
        while (pageCursor.next()) {
            PageHeader page;
            Bytes pageData = pageCursor.getBytes();
            if (!hasData.hasData(pageData, page = PageHeader.parse(pageData, u64, pageCursor.getIndex()), u64)) continue;
            return page;
        }
        throw new IOException("No data page found");
    }

    static interface HasData {
        public boolean hasData(BytesReader var1, PageHeader var2, boolean var3);
    }
}

