/*
 * Decompiled with CFR 0.152.
 */
package internal.ri.data.rows;

import internal.bytes.Bytes;
import internal.bytes.BytesReader;
import internal.ri.base.Header;
import internal.ri.base.PageCursor;
import internal.ri.base.PageHeader;
import internal.ri.base.PageType;
import internal.ri.base.SubHeaderFormat;
import internal.ri.base.SubHeaderLocation;
import internal.ri.base.SubHeaderPointer;
import internal.ri.data.RowSize;
import internal.ri.data.rows.Decompressor;
import internal.ri.data.rows.ForwardingCursor;
import internal.ri.data.rows.RowCursor;
import java.io.IOException;
import java.nio.channels.SeekableByteChannel;
import org.checkerframework.checker.nullness.qual.NonNull;

final class CompressedForwardingCursor
extends ForwardingCursor {
    private final PageCursor pageCursor;
    private final boolean u64;
    private final int count;
    private final SubHeaderLocation lastMetaLocation;
    private final Decompressor decompressor;
    private final Bytes rowBytes;
    private int index;
    private PageHeader currentPage;
    private SubHeaderPointer currentPointer;
    private SubHeaderPointer nextPointer;
    private boolean rowLoaded;

    public static @NonNull RowCursor of(@NonNull SeekableByteChannel sbc, @NonNull Header header, @NonNull RowSize rowSize, @NonNull Decompressor decompressor) {
        return new CompressedForwardingCursor(PageCursor.of(sbc, header), header.isU64(), rowSize.getCount(), rowSize.getLastMeta(), decompressor, Bytes.allocate(rowSize.getLength(), header.getEndianness()), -1, null, null, null, false);
    }

    @Override
    protected boolean hasNextRow() {
        return this.index + 1 < this.count;
    }

    @Override
    protected boolean hasNextRowInCurrentPage() throws IOException {
        if (this.currentPointer != null && this.currentPointer.getLocation().getIndex() < this.currentPage.getSubHeaderCount()) {
            this.nextPointer = SubHeaderPointer.parse(this.pageCursor.getBytes(), this.u64, this.currentPointer.getLocation().next());
            return !this.nextPointer.getFormat().isKnownAs(SubHeaderFormat.TRUNCATED);
        }
        return false;
    }

    @Override
    protected void moveToNextRowInCurrentPage() throws IOException {
        this.currentPointer = this.nextPointer;
        this.nextPointer = null;
        this.rowLoaded = false;
        ++this.index;
    }

    @Override
    protected void moveToFirstRowInNextPage() throws IOException {
        if (this.currentPage == null) {
            this.pageCursor.moveTo(this.lastMetaLocation.getPage());
            this.currentPage = PageHeader.parse(this.pageCursor.getBytes(), this.u64, this.pageCursor.getIndex());
            this.currentPointer = SubHeaderPointer.parse(this.pageCursor.getBytes(), this.u64, this.lastMetaLocation.next());
        } else {
            this.currentPage = ForwardingCursor.nextPageWithData(this.pageCursor, this.u64, CompressedForwardingCursor::hasData);
            this.currentPointer = SubHeaderPointer.parse(this.pageCursor.getBytes(), this.u64, new SubHeaderLocation(this.currentPage.getIndex(), 0));
        }
        this.nextPointer = null;
        this.rowLoaded = false;
        ++this.index;
    }

    @Override
    protected boolean isDeleted() throws IOException {
        return false;
    }

    @Override
    public BytesReader getBytes() throws IOException {
        if (!this.rowLoaded) {
            if (this.isCurrentRowNotCompressed()) {
                this.pageCursor.getBytes().copyTo(this.currentPointer.getOffset(), this.rowBytes, 0, this.rowBytes.getLength());
            } else {
                this.decompressor.uncompress(this.pageCursor.getBytes(), this.currentPointer.getOffset(), this.rowBytes, this.currentPointer.getLength());
            }
            this.rowLoaded = true;
        }
        return this.rowBytes;
    }

    private boolean isCurrentRowNotCompressed() {
        return this.currentPointer.getLength() == this.rowBytes.getLength();
    }

    private static boolean hasData(BytesReader pageBytes, PageHeader page, boolean u64) {
        return page.getType().isKnownAs(PageType.META);
    }

    private CompressedForwardingCursor(PageCursor pageCursor, boolean u64, int count, SubHeaderLocation lastMetaLocation, Decompressor decompressor, Bytes rowBytes, int index, PageHeader currentPage, SubHeaderPointer currentPointer, SubHeaderPointer nextPointer, boolean rowLoaded) {
        this.pageCursor = pageCursor;
        this.u64 = u64;
        this.count = count;
        this.lastMetaLocation = lastMetaLocation;
        this.decompressor = decompressor;
        this.rowBytes = rowBytes;
        this.index = index;
        this.currentPage = currentPage;
        this.currentPointer = currentPointer;
        this.nextPointer = nextPointer;
        this.rowLoaded = rowLoaded;
    }

    @Override
    public int getCount() {
        return this.count;
    }

    @Override
    public int getIndex() {
        return this.index;
    }
}

