/*
 * Decompiled with CFR 0.152.
 */
package internal.ri.data.rows;

import internal.bytes.BytesReader;
import internal.bytes.BytesWriter;
import internal.ri.data.rows.Decompressor;

abstract class AbstractDecompressor
implements Decompressor {
    AbstractDecompressor() {
    }

    static void copy(BytesReader src, int srcPos, BytesWriter dst, int dstPos, int length) {
        src.copyTo(srcPos, dst, dstPos, length);
    }

    static void insert(BytesWriter dst, int dstPos, int length, byte value) {
        dst.fill(dstPos, dstPos + length, value);
    }

    static int uint12(byte low, byte high) {
        return AbstractDecompressor.uint4(low) + (AbstractDecompressor.uint8(high) << 4);
    }

    static int uint8(byte value) {
        return value & 0xFF;
    }

    static int uint4(byte value) {
        return value & 0xF;
    }
}

