/*
 * Decompiled with CFR 0.152.
 */
package internal.ri.data;

import internal.bytes.BytesReader;
import internal.bytes.Seq;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class StringRef {
    private final @NonNegative int hdr;
    private final @NonNegative int off;
    private final @NonNegative int len;
    public static final Seq SEQ = Seq.builder().and("hdr", 2).and("off", 2).and("len", 2).build();

    public static @NonNull StringRef parse(@NonNull BytesReader bytes, int base) {
        return new StringRef(bytes.getUInt16(base + SEQ.getOffset(false, 0)), bytes.getUInt16(base + SEQ.getOffset(false, 1)), bytes.getUInt16(base + SEQ.getOffset(false, 2)));
    }

    public StringRef(@NonNegative int hdr, @NonNegative int off, @NonNegative int len) {
        this.hdr = hdr;
        this.off = off;
        this.len = len;
    }

    public @NonNegative int getHdr() {
        return this.hdr;
    }

    public @NonNegative int getOff() {
        return this.off;
    }

    public @NonNegative int getLen() {
        return this.len;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StringRef)) {
            return false;
        }
        StringRef other = (StringRef)o;
        if (this.getHdr() != other.getHdr()) {
            return false;
        }
        if (this.getOff() != other.getOff()) {
            return false;
        }
        return this.getLen() == other.getLen();
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getHdr();
        result = result * 59 + this.getOff();
        result = result * 59 + this.getLen();
        return result;
    }

    public String toString() {
        return "StringRef(hdr=" + this.getHdr() + ", off=" + this.getOff() + ", len=" + this.getLen() + ")";
    }
}

