/*
 * Decompiled with CFR 0.152.
 */
package internal.ri.data;

import internal.bytes.BytesReader;
import internal.bytes.Seq;
import internal.ri.base.SubHeader;
import internal.ri.base.SubHeaderLocation;
import internal.ri.base.SubHeaderPointer;
import internal.ri.data.StringRef;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class RowSize
implements SubHeader {
    @lombok.NonNull
    private final SubHeaderLocation location;
    private final @NonNegative int length;
    private final @NonNegative int count;
    private final @NonNegative int deletedCount;
    private final @NonNegative int firstPageMaxCount;
    @lombok.NonNull
    private final SubHeaderLocation firstMeta;
    @lombok.NonNull
    private final SubHeaderLocation lastMeta;
    @lombok.NonNull
    private final SubHeaderLocation firstRow;
    @lombok.NonNull
    private final SubHeaderLocation lastRow;
    @lombok.NonNull
    private final SubHeaderLocation firstColLab;
    @lombok.NonNull
    private final StringRef label;
    @lombok.NonNull
    private final StringRef compression;
    @lombok.NonNull
    private final StringRef proc;
    private final @NonNegative short nct;
    private static final Seq PADDED_LOCATION = Seq.builder().and("location", SubHeaderLocation.SEQ).and("zeroes", 2, 6).build();
    public static final Seq SEQ = Seq.builder().and("signature", Seq.U4U8).and("?", Seq.U4U8).and("?", Seq.U4U8).and("?", Seq.U4U8).and("?", Seq.U4U8).and("rowLength", Seq.U4U8).and("rowCount", Seq.U4U8).and("deletedRowCount", Seq.U4U8).and("?", Seq.U4U8).and("ncfl1", Seq.U4U8).and("ncfl2", Seq.U4U8).and("?", Seq.U4U8).and("?", Seq.U4U8).and("pageSize", Seq.U4U8).and("?", Seq.U4U8).and("firstPageMaxCount", Seq.U4U8).and("?", Seq.U4U8).and("?", Seq.U4U8).and("zeroes", 148, 296).and("pageSignature", 4).and("zeroes", 40, 68).and("firstMeta", PADDED_LOCATION).and("lastMeta", PADDED_LOCATION).and("firstRow", PADDED_LOCATION).and("lastRow", PADDED_LOCATION).and("firstColLab", PADDED_LOCATION).and("notUsed", 40, 80).and("?", 6).and("label", StringRef.SEQ).and("?", 6).and("compression", StringRef.SEQ).and("?", 6).and("procedure", StringRef.SEQ).and("notUsed", 36).and("?", 2).and("?", 2).and("nct", 2).and("?", 2).and("?", 2).and("zeroes", 12).and("?", 2).and("zeroes", 27).and("?", 1).and("zeroes", 12).build();

    public static @NonNull RowSize parse(@NonNull BytesReader pageBytes, boolean u64, @NonNull SubHeaderPointer pointer) {
        BytesReader bytes = pointer.slice(pageBytes);
        short nct = bytes.getInt16(u64 ? 748 : 420);
        return new RowSize(pointer.getLocation(), Seq.parseU4U8(bytes, SEQ.getOffset(u64, 5), u64), Seq.parseU4U8(bytes, SEQ.getOffset(u64, 6), u64), Seq.parseU4U8(bytes, SEQ.getOffset(u64, 7), u64), Seq.parseU4U8(bytes, SEQ.getOffset(u64, 15), u64), SubHeaderLocation.parse(bytes, SEQ.getOffset(u64, 21), u64), SubHeaderLocation.parse(bytes, SEQ.getOffset(u64, 22), u64), SubHeaderLocation.parse(bytes, SEQ.getOffset(u64, 23), u64), SubHeaderLocation.parse(bytes, SEQ.getOffset(u64, 24), u64), SubHeaderLocation.parse(bytes, SEQ.getOffset(u64, 25), u64), StringRef.parse(bytes, SEQ.getOffset(u64, 28)), StringRef.parse(bytes, SEQ.getOffset(u64, 30)), StringRef.parse(bytes, SEQ.getOffset(u64, 32)), nct);
    }

    public RowSize(@lombok.NonNull SubHeaderLocation location, @NonNegative int length, @NonNegative int count, @NonNegative int deletedCount, @NonNegative int firstPageMaxCount, @lombok.NonNull SubHeaderLocation firstMeta, @lombok.NonNull SubHeaderLocation lastMeta, @lombok.NonNull SubHeaderLocation firstRow, @lombok.NonNull SubHeaderLocation lastRow, @lombok.NonNull SubHeaderLocation firstColLab, @lombok.NonNull StringRef label, @lombok.NonNull StringRef compression, @lombok.NonNull StringRef proc, @NonNegative short nct) {
        if (location == null) {
            throw new NullPointerException("location is marked non-null but is null");
        }
        if (firstMeta == null) {
            throw new NullPointerException("firstMeta is marked non-null but is null");
        }
        if (lastMeta == null) {
            throw new NullPointerException("lastMeta is marked non-null but is null");
        }
        if (firstRow == null) {
            throw new NullPointerException("firstRow is marked non-null but is null");
        }
        if (lastRow == null) {
            throw new NullPointerException("lastRow is marked non-null but is null");
        }
        if (firstColLab == null) {
            throw new NullPointerException("firstColLab is marked non-null but is null");
        }
        if (label == null) {
            throw new NullPointerException("label is marked non-null but is null");
        }
        if (compression == null) {
            throw new NullPointerException("compression is marked non-null but is null");
        }
        if (proc == null) {
            throw new NullPointerException("proc is marked non-null but is null");
        }
        this.location = location;
        this.length = length;
        this.count = count;
        this.deletedCount = deletedCount;
        this.firstPageMaxCount = firstPageMaxCount;
        this.firstMeta = firstMeta;
        this.lastMeta = lastMeta;
        this.firstRow = firstRow;
        this.lastRow = lastRow;
        this.firstColLab = firstColLab;
        this.label = label;
        this.compression = compression;
        this.proc = proc;
        this.nct = nct;
    }

    @Override
    @lombok.NonNull
    public SubHeaderLocation getLocation() {
        return this.location;
    }

    public @NonNegative int getLength() {
        return this.length;
    }

    public @NonNegative int getCount() {
        return this.count;
    }

    public @NonNegative int getDeletedCount() {
        return this.deletedCount;
    }

    public @NonNegative int getFirstPageMaxCount() {
        return this.firstPageMaxCount;
    }

    @lombok.NonNull
    public SubHeaderLocation getFirstMeta() {
        return this.firstMeta;
    }

    @lombok.NonNull
    public SubHeaderLocation getLastMeta() {
        return this.lastMeta;
    }

    @lombok.NonNull
    public SubHeaderLocation getFirstRow() {
        return this.firstRow;
    }

    @lombok.NonNull
    public SubHeaderLocation getLastRow() {
        return this.lastRow;
    }

    @lombok.NonNull
    public SubHeaderLocation getFirstColLab() {
        return this.firstColLab;
    }

    @lombok.NonNull
    public StringRef getLabel() {
        return this.label;
    }

    @lombok.NonNull
    public StringRef getCompression() {
        return this.compression;
    }

    @lombok.NonNull
    public StringRef getProc() {
        return this.proc;
    }

    public @NonNegative short getNct() {
        return this.nct;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RowSize)) {
            return false;
        }
        RowSize other = (RowSize)o;
        if (this.getLength() != other.getLength()) {
            return false;
        }
        if (this.getCount() != other.getCount()) {
            return false;
        }
        if (this.getDeletedCount() != other.getDeletedCount()) {
            return false;
        }
        if (this.getFirstPageMaxCount() != other.getFirstPageMaxCount()) {
            return false;
        }
        if (this.getNct() != other.getNct()) {
            return false;
        }
        SubHeaderLocation this$location = this.getLocation();
        SubHeaderLocation other$location = other.getLocation();
        if (this$location == null ? other$location != null : !((Object)this$location).equals(other$location)) {
            return false;
        }
        SubHeaderLocation this$firstMeta = this.getFirstMeta();
        SubHeaderLocation other$firstMeta = other.getFirstMeta();
        if (this$firstMeta == null ? other$firstMeta != null : !((Object)this$firstMeta).equals(other$firstMeta)) {
            return false;
        }
        SubHeaderLocation this$lastMeta = this.getLastMeta();
        SubHeaderLocation other$lastMeta = other.getLastMeta();
        if (this$lastMeta == null ? other$lastMeta != null : !((Object)this$lastMeta).equals(other$lastMeta)) {
            return false;
        }
        SubHeaderLocation this$firstRow = this.getFirstRow();
        SubHeaderLocation other$firstRow = other.getFirstRow();
        if (this$firstRow == null ? other$firstRow != null : !((Object)this$firstRow).equals(other$firstRow)) {
            return false;
        }
        SubHeaderLocation this$lastRow = this.getLastRow();
        SubHeaderLocation other$lastRow = other.getLastRow();
        if (this$lastRow == null ? other$lastRow != null : !((Object)this$lastRow).equals(other$lastRow)) {
            return false;
        }
        SubHeaderLocation this$firstColLab = this.getFirstColLab();
        SubHeaderLocation other$firstColLab = other.getFirstColLab();
        if (this$firstColLab == null ? other$firstColLab != null : !((Object)this$firstColLab).equals(other$firstColLab)) {
            return false;
        }
        StringRef this$label = this.getLabel();
        StringRef other$label = other.getLabel();
        if (this$label == null ? other$label != null : !((Object)this$label).equals(other$label)) {
            return false;
        }
        StringRef this$compression = this.getCompression();
        StringRef other$compression = other.getCompression();
        if (this$compression == null ? other$compression != null : !((Object)this$compression).equals(other$compression)) {
            return false;
        }
        StringRef this$proc = this.getProc();
        StringRef other$proc = other.getProc();
        return !(this$proc == null ? other$proc != null : !((Object)this$proc).equals(other$proc));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getLength();
        result = result * 59 + this.getCount();
        result = result * 59 + this.getDeletedCount();
        result = result * 59 + this.getFirstPageMaxCount();
        result = result * 59 + this.getNct();
        SubHeaderLocation $location = this.getLocation();
        result = result * 59 + ($location == null ? 43 : ((Object)$location).hashCode());
        SubHeaderLocation $firstMeta = this.getFirstMeta();
        result = result * 59 + ($firstMeta == null ? 43 : ((Object)$firstMeta).hashCode());
        SubHeaderLocation $lastMeta = this.getLastMeta();
        result = result * 59 + ($lastMeta == null ? 43 : ((Object)$lastMeta).hashCode());
        SubHeaderLocation $firstRow = this.getFirstRow();
        result = result * 59 + ($firstRow == null ? 43 : ((Object)$firstRow).hashCode());
        SubHeaderLocation $lastRow = this.getLastRow();
        result = result * 59 + ($lastRow == null ? 43 : ((Object)$lastRow).hashCode());
        SubHeaderLocation $firstColLab = this.getFirstColLab();
        result = result * 59 + ($firstColLab == null ? 43 : ((Object)$firstColLab).hashCode());
        StringRef $label = this.getLabel();
        result = result * 59 + ($label == null ? 43 : ((Object)$label).hashCode());
        StringRef $compression = this.getCompression();
        result = result * 59 + ($compression == null ? 43 : ((Object)$compression).hashCode());
        StringRef $proc = this.getProc();
        result = result * 59 + ($proc == null ? 43 : ((Object)$proc).hashCode());
        return result;
    }

    public String toString() {
        return "RowSize(location=" + this.getLocation() + ", length=" + this.getLength() + ", count=" + this.getCount() + ", deletedCount=" + this.getDeletedCount() + ", firstPageMaxCount=" + this.getFirstPageMaxCount() + ", firstMeta=" + this.getFirstMeta() + ", lastMeta=" + this.getLastMeta() + ", firstRow=" + this.getFirstRow() + ", lastRow=" + this.getLastRow() + ", firstColLab=" + this.getFirstColLab() + ", label=" + this.getLabel() + ", compression=" + this.getCompression() + ", proc=" + this.getProc() + ", nct=" + this.getNct() + ")";
    }
}

