/*
 * Decompiled with CFR 0.152.
 */
package internal.ri.data;

import internal.bytes.BytesReader;
import internal.bytes.PValue;
import internal.ri.base.Header;
import internal.ri.base.PageHeader;
import internal.ri.base.RowIndex;
import internal.ri.base.SasFile;
import internal.ri.base.SasFileVisitor;
import internal.ri.base.SubHeaderFormat;
import internal.ri.base.SubHeaderPointer;
import internal.ri.data.ColAttr;
import internal.ri.data.ColAttrs;
import internal.ri.data.ColLabs;
import internal.ri.data.ColName;
import internal.ri.data.ColNames;
import internal.ri.data.ColSize;
import internal.ri.data.ColText;
import internal.ri.data.Compression;
import internal.ri.data.DescriptorType;
import internal.ri.data.RowSize;
import internal.ri.data.StringRef;
import internal.ri.data.SubhCnt;
import java.io.IOException;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class Document {
    private final long length;
    private final Header header;
    private final PValue<Compression, String> compression;
    private final RowSize rowSize;
    private final ColSize colSize;
    private final SubhCnt subhCnt;
    private final List<ColText> colTextList;
    private final List<ColName> colNameList;
    private final List<ColAttr> colAttrList;
    private final List<ColLabs> colLabsList;
    private final List<RowIndex> rowIndexList;

    public String getColumnName(int index, Charset charset) {
        return this.getString(this.colNameList.get(index).getName(), charset);
    }

    public String getColumnLabel(int index, Charset charset) {
        return this.getString(this.colLabsList.get(index).getLabel(), charset);
    }

    public String getColumnFormatName(int index, Charset charset) {
        return this.getString(this.colLabsList.get(index).getFormatName(), charset);
    }

    public String getString(StringRef ref, Charset charset) {
        return Document.getString(this.colTextList, this.header.isU64(), ref, charset);
    }

    private static String getString(List<ColText> list, boolean u64, StringRef ref, Charset charset) {
        return list.get(ref.getHdr()).getContent().getString((u64 ? 8 : 4) + ref.getOff(), ref.getLen(), charset);
    }

    public static @NonNull Document parse(@NonNull Path file) throws IOException {
        try (SeekableByteChannel sbc = Files.newByteChannel(file, StandardOpenOption.READ);){
            Document document = Document.parse(sbc);
            return document;
        }
    }

    public static @NonNull Document parse(@NonNull SeekableByteChannel sbc) throws IOException {
        DocumentVisitor v = new DocumentVisitor();
        SasFile.visit(sbc, (SasFileVisitor)v);
        Document.checkDescriptorCount(v.rowSizeList, 1, DescriptorType.ROW_SIZE);
        RowSize rowSize = v.rowSizeList.get(0);
        Document.checkDescriptorCount(v.colSizeList, 1, DescriptorType.COL_SIZE);
        ColSize colSize = v.colSizeList.get(0);
        Document.checkDescriptorCount(v.subhCntList, 1, DescriptorType.SUBH_CNT);
        SubhCnt subhCnt = v.subhCntList.get(0);
        Document.checkDescriptorCount(v.colNameList, colSize.getCount(), DescriptorType.COL_NAMES);
        Document.checkDescriptorCount(v.colAttrList, colSize.getCount(), DescriptorType.COL_ATTRS);
        Document.checkDescriptorCount(v.colLabsList, colSize.getCount(), DescriptorType.COL_LABS);
        if (v.colTextList.isEmpty()) {
            throw new IOException("At least one column-text subheaders expected");
        }
        String compression = Document.getString(v.colTextList, v.header.isU64(), rowSize.getCompression(), StandardCharsets.US_ASCII);
        return new Document(sbc.size(), v.header, Compression.tryParse(compression), rowSize, colSize, subhCnt, v.colTextList, v.colNameList, v.colAttrList, v.colLabsList, v.rowIndexList);
    }

    private static void checkDescriptorCount(List<?> list, int expectedSize, DescriptorType type) throws IOException {
        if (list.size() != expectedSize) {
            throw new IOException("Invalid count of descriptor " + type + ", expected:" + expectedSize + ", actual:" + list.size());
        }
    }

    public Document(long length, Header header, PValue<Compression, String> compression, RowSize rowSize, ColSize colSize, SubhCnt subhCnt, List<ColText> colTextList, List<ColName> colNameList, List<ColAttr> colAttrList, List<ColLabs> colLabsList, List<RowIndex> rowIndexList) {
        this.length = length;
        this.header = header;
        this.compression = compression;
        this.rowSize = rowSize;
        this.colSize = colSize;
        this.subhCnt = subhCnt;
        this.colTextList = colTextList;
        this.colNameList = colNameList;
        this.colAttrList = colAttrList;
        this.colLabsList = colLabsList;
        this.rowIndexList = rowIndexList;
    }

    public long getLength() {
        return this.length;
    }

    public Header getHeader() {
        return this.header;
    }

    public PValue<Compression, String> getCompression() {
        return this.compression;
    }

    public RowSize getRowSize() {
        return this.rowSize;
    }

    public ColSize getColSize() {
        return this.colSize;
    }

    public SubhCnt getSubhCnt() {
        return this.subhCnt;
    }

    public List<ColText> getColTextList() {
        return this.colTextList;
    }

    public List<ColName> getColNameList() {
        return this.colNameList;
    }

    public List<ColAttr> getColAttrList() {
        return this.colAttrList;
    }

    public List<ColLabs> getColLabsList() {
        return this.colLabsList;
    }

    public List<RowIndex> getRowIndexList() {
        return this.rowIndexList;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Document)) {
            return false;
        }
        Document other = (Document)o;
        if (this.getLength() != other.getLength()) {
            return false;
        }
        Header this$header = this.getHeader();
        Header other$header = other.getHeader();
        if (this$header == null ? other$header != null : !((Object)this$header).equals(other$header)) {
            return false;
        }
        PValue<Compression, String> this$compression = this.getCompression();
        PValue<Compression, String> other$compression = other.getCompression();
        if (this$compression == null ? other$compression != null : !((Object)this$compression).equals(other$compression)) {
            return false;
        }
        RowSize this$rowSize = this.getRowSize();
        RowSize other$rowSize = other.getRowSize();
        if (this$rowSize == null ? other$rowSize != null : !((Object)this$rowSize).equals(other$rowSize)) {
            return false;
        }
        ColSize this$colSize = this.getColSize();
        ColSize other$colSize = other.getColSize();
        if (this$colSize == null ? other$colSize != null : !((Object)this$colSize).equals(other$colSize)) {
            return false;
        }
        SubhCnt this$subhCnt = this.getSubhCnt();
        SubhCnt other$subhCnt = other.getSubhCnt();
        if (this$subhCnt == null ? other$subhCnt != null : !((Object)this$subhCnt).equals(other$subhCnt)) {
            return false;
        }
        List<ColText> this$colTextList = this.getColTextList();
        List<ColText> other$colTextList = other.getColTextList();
        if (this$colTextList == null ? other$colTextList != null : !((Object)this$colTextList).equals(other$colTextList)) {
            return false;
        }
        List<ColName> this$colNameList = this.getColNameList();
        List<ColName> other$colNameList = other.getColNameList();
        if (this$colNameList == null ? other$colNameList != null : !((Object)this$colNameList).equals(other$colNameList)) {
            return false;
        }
        List<ColAttr> this$colAttrList = this.getColAttrList();
        List<ColAttr> other$colAttrList = other.getColAttrList();
        if (this$colAttrList == null ? other$colAttrList != null : !((Object)this$colAttrList).equals(other$colAttrList)) {
            return false;
        }
        List<ColLabs> this$colLabsList = this.getColLabsList();
        List<ColLabs> other$colLabsList = other.getColLabsList();
        if (this$colLabsList == null ? other$colLabsList != null : !((Object)this$colLabsList).equals(other$colLabsList)) {
            return false;
        }
        List<RowIndex> this$rowIndexList = this.getRowIndexList();
        List<RowIndex> other$rowIndexList = other.getRowIndexList();
        return !(this$rowIndexList == null ? other$rowIndexList != null : !((Object)this$rowIndexList).equals(other$rowIndexList));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $length = this.getLength();
        result = result * 59 + (int)($length >>> 32 ^ $length);
        Header $header = this.getHeader();
        result = result * 59 + ($header == null ? 43 : ((Object)$header).hashCode());
        PValue<Compression, String> $compression = this.getCompression();
        result = result * 59 + ($compression == null ? 43 : ((Object)$compression).hashCode());
        RowSize $rowSize = this.getRowSize();
        result = result * 59 + ($rowSize == null ? 43 : ((Object)$rowSize).hashCode());
        ColSize $colSize = this.getColSize();
        result = result * 59 + ($colSize == null ? 43 : ((Object)$colSize).hashCode());
        SubhCnt $subhCnt = this.getSubhCnt();
        result = result * 59 + ($subhCnt == null ? 43 : ((Object)$subhCnt).hashCode());
        List<ColText> $colTextList = this.getColTextList();
        result = result * 59 + ($colTextList == null ? 43 : ((Object)$colTextList).hashCode());
        List<ColName> $colNameList = this.getColNameList();
        result = result * 59 + ($colNameList == null ? 43 : ((Object)$colNameList).hashCode());
        List<ColAttr> $colAttrList = this.getColAttrList();
        result = result * 59 + ($colAttrList == null ? 43 : ((Object)$colAttrList).hashCode());
        List<ColLabs> $colLabsList = this.getColLabsList();
        result = result * 59 + ($colLabsList == null ? 43 : ((Object)$colLabsList).hashCode());
        List<RowIndex> $rowIndexList = this.getRowIndexList();
        result = result * 59 + ($rowIndexList == null ? 43 : ((Object)$rowIndexList).hashCode());
        return result;
    }

    public String toString() {
        return "Document(length=" + this.getLength() + ", header=" + this.getHeader() + ", compression=" + this.getCompression() + ", rowSize=" + this.getRowSize() + ", colSize=" + this.getColSize() + ", subhCnt=" + this.getSubhCnt() + ", colTextList=" + this.getColTextList() + ", colNameList=" + this.getColNameList() + ", colAttrList=" + this.getColAttrList() + ", colLabsList=" + this.getColLabsList() + ", rowIndexList=" + this.getRowIndexList() + ")";
    }

    private static final class DocumentVisitor
    implements SasFileVisitor {
        Header header;
        final List<RowSize> rowSizeList = new ArrayList<RowSize>();
        final List<ColSize> colSizeList = new ArrayList<ColSize>();
        final List<ColAttr> colAttrList = new ArrayList<ColAttr>();
        final List<ColName> colNameList = new ArrayList<ColName>();
        final List<ColLabs> colLabsList = new ArrayList<ColLabs>();
        final List<ColText> colTextList = new ArrayList<ColText>();
        final List<RowIndex> rowIndexList = new ArrayList<RowIndex>();
        final List<SubhCnt> subhCntList = new ArrayList<SubhCnt>();

        private DocumentVisitor() {
        }

        @Override
        public FileVisitResult onHeader(Header header) {
            this.header = header;
            return FileVisitResult.CONTINUE;
        }

        private boolean hasRemainingMeta() {
            return this.rowSizeList.size() == 1 && this.rowSizeList.get(0).getNct() > this.colTextList.size();
        }

        @Override
        public FileVisitResult onPage(Header header, PageHeader page, BytesReader pageData) {
            if (page.getType().isKnown()) {
                switch (page.getType().get()) {
                    case META: 
                    case MIX: 
                    case AMD: 
                    case INDEX: {
                        return FileVisitResult.CONTINUE;
                    }
                }
            }
            return this.hasRemainingMeta() ? FileVisitResult.CONTINUE : FileVisitResult.TERMINATE;
        }

        @Override
        public FileVisitResult onSubHeaderPointer(Header header, PageHeader page, BytesReader pageData, SubHeaderPointer pointer) {
            if (pointer.getFormat().isKnownAs(SubHeaderFormat.PLAIN)) {
                Optional<PValue<DescriptorType, String>> type = DescriptorType.tryParse(pageData, header.isU64(), pointer);
                if (type.isPresent() && type.get().isKnown()) {
                    switch (type.get().get()) {
                        case ROW_SIZE: {
                            this.rowSizeList.add(RowSize.parse(pageData, header.isU64(), pointer));
                            break;
                        }
                        case COL_SIZE: {
                            this.colSizeList.add(ColSize.parse(pageData, header.isU64(), pointer));
                            break;
                        }
                        case COL_ATTRS: {
                            this.colAttrList.addAll(ColAttrs.parse(pageData, header.isU64(), pointer).getItems());
                            break;
                        }
                        case COL_NAMES: {
                            this.colNameList.addAll(ColNames.parse(pageData, header.isU64(), pointer).getItems());
                            break;
                        }
                        case COL_LABS: {
                            this.colLabsList.add(ColLabs.parse(pageData, header.isU64(), pointer));
                            break;
                        }
                        case COL_TEXT: {
                            this.colTextList.add(ColText.parse(pageData, header.isU64(), pointer));
                            break;
                        }
                        case SUBH_CNT: {
                            this.subhCntList.add(SubhCnt.parse(pageData, header.isU64(), pointer));
                        }
                    }
                }
                return FileVisitResult.CONTINUE;
            }
            return FileVisitResult.SKIP_SIBLINGS;
        }

        @Override
        public FileVisitResult onRowIndex(Header header, PageHeader page, BytesReader pageData, RowIndex rowIndex) {
            this.rowIndexList.add(rowIndex);
            return FileVisitResult.CONTINUE;
        }
    }
}

