/*
 * Decompiled with CFR 0.152.
 */
package internal.ri.data;

import internal.bytes.BytesReader;
import internal.bytes.PValue;
import internal.ri.base.Header;
import internal.ri.base.SubHeader;
import internal.ri.base.SubHeaderFormat;
import internal.ri.base.SubHeaderPointer;
import internal.ri.data.ColAttrs;
import internal.ri.data.ColLabs;
import internal.ri.data.ColList;
import internal.ri.data.ColNames;
import internal.ri.data.ColSize;
import internal.ri.data.ColText;
import internal.ri.data.RowSize;
import internal.ri.data.SubhCnt;
import java.io.IOException;
import java.nio.channels.SeekableByteChannel;
import java.util.Optional;

public enum DescriptorType implements SubHeader.Parser
{
    ROW_SIZE(RowSize::parse),
    COL_SIZE(ColSize::parse),
    COL_TEXT(ColText::parse),
    COL_ATTRS(ColAttrs::parse),
    COL_NAMES(ColNames::parse),
    COL_LABS(ColLabs::parse),
    COL_LIST(ColList::parse),
    SUBH_CNT(SubhCnt::parse);

    private final SubHeader.Parser parser;

    private static PValue<DescriptorType, String> tryParse32(int value) {
        switch (value) {
            case -134744073: {
                return PValue.known(ROW_SIZE);
            }
            case -151587082: {
                return PValue.known(COL_SIZE);
            }
            case -3: {
                return PValue.known(COL_TEXT);
            }
            case -4: {
                return PValue.known(COL_ATTRS);
            }
            case -1: {
                return PValue.known(COL_NAMES);
            }
            case -1026: {
                return PValue.known(COL_LABS);
            }
            case -2: {
                return PValue.known(COL_LIST);
            }
            case -1024: {
                return PValue.known(SUBH_CNT);
            }
        }
        return PValue.unknown(Integer.toHexString(value));
    }

    private static PValue<DescriptorType, String> tryParse64(long value) {
        String hex;
        switch (hex = Long.toHexString(value)) {
            case "f7f7f7f7": 
            case "f7f7f7f700000000": 
            case "f7f7f7f7fffffbfe": {
                return PValue.known(ROW_SIZE);
            }
            case "f6f6f6f6": 
            case "f6f6f6f600000000": 
            case "f6f6f6f6fffffbfe": {
                return PValue.known(COL_SIZE);
            }
            case "fffffffffffffffd": {
                return PValue.known(COL_TEXT);
            }
            case "fffffffffffffffc": {
                return PValue.known(COL_ATTRS);
            }
            case "ffffffffffffffff": {
                return PValue.known(COL_NAMES);
            }
            case "fffffffffffffbfe": {
                return PValue.known(COL_LABS);
            }
            case "fffffffffffffffe": {
                return PValue.known(COL_LIST);
            }
            case "fffffffffffffc00": {
                return PValue.known(SUBH_CNT);
            }
        }
        return PValue.unknown(hex);
    }

    public static Optional<PValue<DescriptorType, String>> tryParse(BytesReader pageBytes, boolean u64, SubHeaderPointer pointer) {
        if (pointer.getFormat().isKnownAs(SubHeaderFormat.PLAIN) && pointer.hasContent()) {
            int offset = pointer.getOffset();
            return u64 ? Optional.of(DescriptorType.tryParse64(pageBytes.getInt64(offset))) : Optional.of(DescriptorType.tryParse32(pageBytes.getInt32(offset)));
        }
        return Optional.empty();
    }

    private DescriptorType(SubHeader.Parser parser) {
        this.parser = parser;
    }

    @Override
    public SubHeader parse(BytesReader pageBytes, boolean u64, SubHeaderPointer pointer) {
        return this.parser.parse(pageBytes, u64, pointer);
    }

    @Override
    public SubHeader parse(SeekableByteChannel file, Header header, SubHeaderPointer pointer) throws IOException {
        return this.parser.parse(file, header, pointer);
    }
}

