/*
 * Decompiled with CFR 0.152.
 */
package internal.ri.data;

import internal.bytes.Bytes;
import internal.bytes.BytesReader;
import internal.ri.base.SubHeader;
import internal.ri.base.SubHeaderLocation;
import internal.ri.base.SubHeaderPointer;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class ColText
implements SubHeader {
    @lombok.NonNull
    private final SubHeaderLocation location;
    @lombok.NonNull
    private final BytesReader content;

    public static @NonNull ColText parse(@NonNull BytesReader pageBytes, boolean u64, @NonNull SubHeaderPointer pointer) {
        byte[] copied = pointer.slice(pageBytes).toArray();
        return new ColText(pointer.getLocation(), Bytes.wrap(copied, pageBytes.getOrder()));
    }

    public ColText(@lombok.NonNull SubHeaderLocation location, @lombok.NonNull BytesReader content) {
        if (location == null) {
            throw new NullPointerException("location is marked non-null but is null");
        }
        if (content == null) {
            throw new NullPointerException("content is marked non-null but is null");
        }
        this.location = location;
        this.content = content;
    }

    @Override
    @lombok.NonNull
    public SubHeaderLocation getLocation() {
        return this.location;
    }

    @lombok.NonNull
    public BytesReader getContent() {
        return this.content;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ColText)) {
            return false;
        }
        ColText other = (ColText)o;
        SubHeaderLocation this$location = this.getLocation();
        SubHeaderLocation other$location = other.getLocation();
        if (this$location == null ? other$location != null : !((Object)this$location).equals(other$location)) {
            return false;
        }
        BytesReader this$content = this.getContent();
        BytesReader other$content = other.getContent();
        return !(this$content == null ? other$content != null : !this$content.equals(other$content));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SubHeaderLocation $location = this.getLocation();
        result = result * 59 + ($location == null ? 43 : ((Object)$location).hashCode());
        BytesReader $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        return result;
    }

    public String toString() {
        return "ColText(location=" + this.getLocation() + ", content=" + this.getContent() + ")";
    }
}

