/*
 * Decompiled with CFR 0.152.
 */
package internal.ri.data;

import internal.bytes.BytesReader;
import internal.bytes.Seq;
import internal.ri.base.SubHeader;
import internal.ri.base.SubHeaderLocation;
import internal.ri.base.SubHeaderPointer;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class ColSize
implements SubHeader {
    @lombok.NonNull
    private final SubHeaderLocation location;
    private final @NonNegative int count;
    public static final Seq SEQ = Seq.builder().and("signature", Seq.U4U8).and("columnCount", Seq.U4U8).and("?", Seq.U4U8).build();

    public static @NonNull ColSize parse(@NonNull BytesReader pageBytes, boolean u64, @NonNull SubHeaderPointer pointer) {
        BytesReader bytes = pointer.slice(pageBytes);
        return new ColSize(pointer.getLocation(), Seq.parseU4U8(bytes, SEQ.getOffset(u64, 1), u64));
    }

    public ColSize(@lombok.NonNull SubHeaderLocation location, @NonNegative int count) {
        if (location == null) {
            throw new NullPointerException("location is marked non-null but is null");
        }
        this.location = location;
        this.count = count;
    }

    @Override
    @lombok.NonNull
    public SubHeaderLocation getLocation() {
        return this.location;
    }

    public @NonNegative int getCount() {
        return this.count;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ColSize)) {
            return false;
        }
        ColSize other = (ColSize)o;
        if (this.getCount() != other.getCount()) {
            return false;
        }
        SubHeaderLocation this$location = this.getLocation();
        SubHeaderLocation other$location = other.getLocation();
        return !(this$location == null ? other$location != null : !((Object)this$location).equals(other$location));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCount();
        SubHeaderLocation $location = this.getLocation();
        result = result * 59 + ($location == null ? 43 : ((Object)$location).hashCode());
        return result;
    }

    public String toString() {
        return "ColSize(location=" + this.getLocation() + ", count=" + this.getCount() + ")";
    }
}

