/*
 * Decompiled with CFR 0.152.
 */
package internal.ri.data;

import internal.bytes.BytesReader;
import internal.bytes.Record;
import internal.ri.base.SubHeader;
import internal.ri.base.SubHeaderLocation;
import internal.ri.base.SubHeaderPointer;
import internal.ri.data.ColName;
import internal.ri.data.StringRef;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class ColNames
implements SubHeader {
    @lombok.NonNull
    private final SubHeaderLocation location;
    @lombok.NonNull
    private final List<ColName> items;

    public static @NonNull ColNames parse(@NonNull BytesReader pageBytes, boolean u64, @NonNull SubHeaderPointer pointer) {
        return ColNames.parse(pointer.slice(pageBytes), u64, pointer.getLocation());
    }

    private static ColNames parse(BytesReader bytes, boolean u64, SubHeaderLocation location) {
        int length = ColName.SEQ.getTotalLength(u64);
        int count = (bytes.getLength() - (u64 ? 28 : 20)) / length;
        int offset = u64 ? 16 : 12;
        return new ColNames(location, Record.toList(count, offset, length, ColNames.getFactory(bytes, location)));
    }

    private static Record.BiIntFunction<ColName> getFactory(BytesReader bytes, SubHeaderLocation location) {
        return (i, base) -> new ColName(location, i, StringRef.parse(bytes, base));
    }

    public ColNames(@lombok.NonNull SubHeaderLocation location, @lombok.NonNull List<ColName> items) {
        if (location == null) {
            throw new NullPointerException("location is marked non-null but is null");
        }
        if (items == null) {
            throw new NullPointerException("items is marked non-null but is null");
        }
        this.location = location;
        this.items = items;
    }

    @Override
    @lombok.NonNull
    public SubHeaderLocation getLocation() {
        return this.location;
    }

    @lombok.NonNull
    public List<ColName> getItems() {
        return this.items;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ColNames)) {
            return false;
        }
        ColNames other = (ColNames)o;
        SubHeaderLocation this$location = this.getLocation();
        SubHeaderLocation other$location = other.getLocation();
        if (this$location == null ? other$location != null : !((Object)this$location).equals(other$location)) {
            return false;
        }
        List<ColName> this$items = this.getItems();
        List<ColName> other$items = other.getItems();
        return !(this$items == null ? other$items != null : !((Object)this$items).equals(other$items));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SubHeaderLocation $location = this.getLocation();
        result = result * 59 + ($location == null ? 43 : ((Object)$location).hashCode());
        List<ColName> $items = this.getItems();
        result = result * 59 + ($items == null ? 43 : ((Object)$items).hashCode());
        return result;
    }

    public String toString() {
        return "ColNames(location=" + this.getLocation() + ", items=" + this.getItems() + ")";
    }
}

