/*
 * Decompiled with CFR 0.152.
 */
package internal.ri.data;

import internal.bytes.BytesReader;
import internal.bytes.Seq;
import internal.ri.base.SubHeader;
import internal.ri.base.SubHeaderLocation;
import internal.ri.base.SubHeaderPointer;
import internal.ri.data.StringRef;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class ColLabs
implements SubHeader {
    @lombok.NonNull
    private final SubHeaderLocation location;
    private final @NonNegative int formatWidth;
    private final @NonNegative int formatPrecision;
    private final @NonNull StringRef formatName;
    private final @NonNull StringRef label;
    public static final Seq SEQ = Seq.builder().and("signature", Seq.U4U8).and("?", 8).and("width", 2).and("precision", 2).and("?", 18, 26).and("format", StringRef.SEQ).and("label", StringRef.SEQ).build();

    public static @NonNull ColLabs parse(@NonNull BytesReader pageBytes, boolean u64, @NonNull SubHeaderPointer pointer) {
        return ColLabs.parse(pointer.slice(pageBytes), u64, pointer.getLocation());
    }

    private static ColLabs parse(BytesReader bytes, boolean u64, SubHeaderLocation location) {
        return new ColLabs(location, bytes.getUInt16(SEQ.getOffset(u64, 2)), bytes.getUInt16(SEQ.getOffset(u64, 3)), StringRef.parse(bytes, SEQ.getOffset(u64, 5)), StringRef.parse(bytes, SEQ.getOffset(u64, 6)));
    }

    public ColLabs(@lombok.NonNull SubHeaderLocation location, @NonNegative int formatWidth, @NonNegative int formatPrecision, @NonNull StringRef formatName, @NonNull StringRef label) {
        if (location == null) {
            throw new NullPointerException("location is marked non-null but is null");
        }
        if (formatName == null) {
            throw new NullPointerException("formatName is marked non-null but is null");
        }
        if (label == null) {
            throw new NullPointerException("label is marked non-null but is null");
        }
        this.location = location;
        this.formatWidth = formatWidth;
        this.formatPrecision = formatPrecision;
        this.formatName = formatName;
        this.label = label;
    }

    @Override
    @lombok.NonNull
    public SubHeaderLocation getLocation() {
        return this.location;
    }

    public @NonNegative int getFormatWidth() {
        return this.formatWidth;
    }

    public @NonNegative int getFormatPrecision() {
        return this.formatPrecision;
    }

    public @NonNull StringRef getFormatName() {
        return this.formatName;
    }

    public @NonNull StringRef getLabel() {
        return this.label;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ColLabs)) {
            return false;
        }
        ColLabs other = (ColLabs)o;
        if (this.getFormatWidth() != other.getFormatWidth()) {
            return false;
        }
        if (this.getFormatPrecision() != other.getFormatPrecision()) {
            return false;
        }
        SubHeaderLocation this$location = this.getLocation();
        SubHeaderLocation other$location = other.getLocation();
        if (this$location == null ? other$location != null : !((Object)this$location).equals(other$location)) {
            return false;
        }
        StringRef this$formatName = this.getFormatName();
        StringRef other$formatName = other.getFormatName();
        if (this$formatName == null ? other$formatName != null : !((Object)this$formatName).equals(other$formatName)) {
            return false;
        }
        StringRef this$label = this.getLabel();
        StringRef other$label = other.getLabel();
        return !(this$label == null ? other$label != null : !((Object)this$label).equals(other$label));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getFormatWidth();
        result = result * 59 + this.getFormatPrecision();
        SubHeaderLocation $location = this.getLocation();
        result = result * 59 + ($location == null ? 43 : ((Object)$location).hashCode());
        StringRef $formatName = this.getFormatName();
        result = result * 59 + ($formatName == null ? 43 : ((Object)$formatName).hashCode());
        StringRef $label = this.getLabel();
        result = result * 59 + ($label == null ? 43 : ((Object)$label).hashCode());
        return result;
    }

    public String toString() {
        return "ColLabs(location=" + this.getLocation() + ", formatWidth=" + this.getFormatWidth() + ", formatPrecision=" + this.getFormatPrecision() + ", formatName=" + this.getFormatName() + ", label=" + this.getLabel() + ")";
    }
}

