/*
 * Decompiled with CFR 0.152.
 */
package internal.ri.data;

import internal.bytes.BytesReader;
import internal.bytes.Seq;
import internal.ri.base.SubHeader;
import internal.ri.base.SubHeaderLocation;
import internal.ri.base.SubHeaderPointer;
import internal.ri.data.ColAttr;
import internal.ri.data.ColType;
import java.util.Arrays;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class ColAttrs
implements SubHeader {
    @lombok.NonNull
    private final SubHeaderLocation location;
    @lombok.NonNull
    private final List<ColAttr> items;

    public static @NonNull ColAttrs parse(@NonNull BytesReader pageBytes, boolean u64, @NonNull SubHeaderPointer pointer) {
        return ColAttrs.parse(pointer.slice(pageBytes), u64, pointer.getLocation());
    }

    private static ColAttrs parse(BytesReader bytes, boolean u64, SubHeaderLocation location) {
        int lcav = ColAttrs.getAttributeVectorLength(u64);
        int count = (bytes.getLength() - (u64 ? 28 : 20)) / lcav;
        int offset = lcav;
        int length = lcav;
        int columnWitdhOffset = ColAttrs.getColumnWidthOffset(u64);
        int columnTypeOffset = ColAttrs.getColumnTypeOffset(u64);
        ColAttr[] result = new ColAttr[count];
        for (int i = 0; i < result.length; ++i) {
            int base = offset + i * length;
            int columnOffsetInDataRow = Seq.parseU4U8(bytes, base, u64);
            int columnWidth = bytes.getInt32(base + columnWitdhOffset);
            byte columnType = bytes.getByte(base + columnTypeOffset);
            result[i] = new ColAttr(location, i, columnOffsetInDataRow, columnWidth, ColType.tryParse(columnType));
        }
        return new ColAttrs(location, Arrays.asList(result));
    }

    private static int getColumnWidthOffset(boolean u64) {
        return u64 ? 8 : 4;
    }

    private static int getColumnTypeOffset(boolean u64) {
        return u64 ? 14 : 10;
    }

    private static int getAttributeVectorLength(boolean u64) {
        return u64 ? 16 : 12;
    }

    public ColAttrs(@lombok.NonNull SubHeaderLocation location, @lombok.NonNull List<ColAttr> items) {
        if (location == null) {
            throw new NullPointerException("location is marked non-null but is null");
        }
        if (items == null) {
            throw new NullPointerException("items is marked non-null but is null");
        }
        this.location = location;
        this.items = items;
    }

    @Override
    @lombok.NonNull
    public SubHeaderLocation getLocation() {
        return this.location;
    }

    @lombok.NonNull
    public List<ColAttr> getItems() {
        return this.items;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ColAttrs)) {
            return false;
        }
        ColAttrs other = (ColAttrs)o;
        SubHeaderLocation this$location = this.getLocation();
        SubHeaderLocation other$location = other.getLocation();
        if (this$location == null ? other$location != null : !((Object)this$location).equals(other$location)) {
            return false;
        }
        List<ColAttr> this$items = this.getItems();
        List<ColAttr> other$items = other.getItems();
        return !(this$items == null ? other$items != null : !((Object)this$items).equals(other$items));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SubHeaderLocation $location = this.getLocation();
        result = result * 59 + ($location == null ? 43 : ((Object)$location).hashCode());
        List<ColAttr> $items = this.getItems();
        result = result * 59 + ($items == null ? 43 : ((Object)$items).hashCode());
        return result;
    }

    public String toString() {
        return "ColAttrs(location=" + this.getLocation() + ", items=" + this.getItems() + ")";
    }
}

