/*
 * Decompiled with CFR 0.152.
 */
package internal.ri.base;

import internal.bytes.BytesReader;
import internal.bytes.PValue;
import internal.bytes.Record;
import internal.bytes.Seq;
import internal.ri.base.PageHeader;
import internal.ri.base.SubHeaderFormat;
import internal.ri.base.SubHeaderLocation;
import java.util.List;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class SubHeaderPointer {
    @lombok.NonNull
    private final SubHeaderLocation location;
    private final @NonNegative int offset;
    private final @NonNegative int length;
    private final @NonNull PValue<SubHeaderFormat, Byte> format;
    private static final Seq SEQ = Seq.builder().and("offset", Seq.U4U8).and("length", Seq.U4U8).and("format", 1).and("st", 1).and("zeroes", 2, 6).build();

    public @NonNull BytesReader slice(@NonNull BytesReader bytes) {
        return bytes.slice(this.offset, this.length);
    }

    public boolean hasContent() {
        return this.length > 0;
    }

    public static @NonNull SubHeaderPointer parse(@NonNull BytesReader pageBytes, boolean u64, @NonNull SubHeaderLocation location) {
        int offset = SubHeaderPointer.getOffset(u64);
        int length = SubHeaderPointer.getLength(u64);
        return SubHeaderPointer.parse(pageBytes, u64, location, Record.getBase(offset, length, location.getIndex()));
    }

    public static @NonNull List<SubHeaderPointer> parseAll(@NonNull BytesReader pageBytes, boolean u64, @NonNull PageHeader page) {
        short count = page.getSubHeaderCount();
        int offset = SubHeaderPointer.getOffset(u64);
        int length = SubHeaderPointer.getLength(u64);
        return Record.toList((int)count, offset, length, (i, base) -> SubHeaderPointer.parse(pageBytes, u64, new SubHeaderLocation(page.getIndex(), i), base));
    }

    private static SubHeaderPointer parse(BytesReader pageBytes, boolean u64, SubHeaderLocation location, int base) {
        int offset = Seq.parseU4U8(pageBytes, base + SEQ.getOffset(u64, 0), u64);
        int length = Seq.parseU4U8(pageBytes, base + SEQ.getOffset(u64, 1), u64);
        byte format = pageBytes.getByte(base + SEQ.getOffset(u64, 2));
        return new SubHeaderPointer(location, offset, length, SubHeaderFormat.tryParse(format));
    }

    private static int getOffset(boolean u64) {
        return PageHeader.getHeadLength(u64);
    }

    private static int getLength(boolean u64) {
        return SEQ.getTotalLength(u64);
    }

    public SubHeaderPointer(@lombok.NonNull SubHeaderLocation location, @NonNegative int offset, @NonNegative int length, @NonNull PValue<SubHeaderFormat, Byte> format) {
        if (location == null) {
            throw new NullPointerException("location is marked non-null but is null");
        }
        if (format == null) {
            throw new NullPointerException("format is marked non-null but is null");
        }
        this.location = location;
        this.offset = offset;
        this.length = length;
        this.format = format;
    }

    @lombok.NonNull
    public SubHeaderLocation getLocation() {
        return this.location;
    }

    public @NonNegative int getOffset() {
        return this.offset;
    }

    public @NonNegative int getLength() {
        return this.length;
    }

    public @NonNull PValue<SubHeaderFormat, Byte> getFormat() {
        return this.format;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SubHeaderPointer)) {
            return false;
        }
        SubHeaderPointer other = (SubHeaderPointer)o;
        if (this.getOffset() != other.getOffset()) {
            return false;
        }
        if (this.getLength() != other.getLength()) {
            return false;
        }
        SubHeaderLocation this$location = this.getLocation();
        SubHeaderLocation other$location = other.getLocation();
        if (this$location == null ? other$location != null : !((Object)this$location).equals(other$location)) {
            return false;
        }
        PValue<SubHeaderFormat, Byte> this$format = this.getFormat();
        PValue<SubHeaderFormat, Byte> other$format = other.getFormat();
        return !(this$format == null ? other$format != null : !((Object)this$format).equals(other$format));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getOffset();
        result = result * 59 + this.getLength();
        SubHeaderLocation $location = this.getLocation();
        result = result * 59 + ($location == null ? 43 : ((Object)$location).hashCode());
        PValue<SubHeaderFormat, Byte> $format = this.getFormat();
        result = result * 59 + ($format == null ? 43 : ((Object)$format).hashCode());
        return result;
    }

    public String toString() {
        return "SubHeaderPointer(location=" + this.getLocation() + ", offset=" + this.getOffset() + ", length=" + this.getLength() + ", format=" + this.getFormat() + ")";
    }
}

