/*
 * Decompiled with CFR 0.152.
 */
package internal.ri.base;

import internal.bytes.BytesReader;
import internal.bytes.Seq;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class SubHeaderLocation
implements Comparable<SubHeaderLocation> {
    private final @NonNegative int page;
    private final @NonNegative int index;
    public static final Seq SEQ = Seq.builder().and("pageNumber", Seq.U4U8).and("subHeaderNumber", 2).build();

    public @NonNull SubHeaderLocation next() {
        return new SubHeaderLocation(this.page, this.index + 1);
    }

    @Override
    public int compareTo(SubHeaderLocation that) {
        int result = Integer.compare(this.page, that.page);
        return result != 0 ? result : Integer.compare(this.index, that.index);
    }

    public static @NonNull SubHeaderLocation parse(@NonNull BytesReader bytes, @NonNegative int base, boolean u64) {
        return new SubHeaderLocation(Seq.parseU4U8(bytes, base + SEQ.getOffset(u64, 0), u64) - 1, bytes.getInt16(base + SEQ.getOffset(u64, 1)) - 1);
    }

    public SubHeaderLocation(@NonNegative int page, @NonNegative int index) {
        this.page = page;
        this.index = index;
    }

    public @NonNegative int getPage() {
        return this.page;
    }

    public @NonNegative int getIndex() {
        return this.index;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SubHeaderLocation)) {
            return false;
        }
        SubHeaderLocation other = (SubHeaderLocation)o;
        if (this.getPage() != other.getPage()) {
            return false;
        }
        return this.getIndex() == other.getIndex();
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPage();
        result = result * 59 + this.getIndex();
        return result;
    }

    public String toString() {
        return "SubHeaderLocation(page=" + this.getPage() + ", index=" + this.getIndex() + ")";
    }
}

