/*
 * Decompiled with CFR 0.152.
 */
package internal.ri.base;

import internal.bytes.Bytes;
import internal.bytes.BytesReader;
import internal.ri.base.Header;
import internal.ri.base.PageCursor;
import internal.ri.base.PageHeader;
import internal.ri.base.RowIndex;
import internal.ri.base.SasFileVisitor;
import internal.ri.base.SubHeaderPointer;
import java.io.IOException;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class SasFile {
    public static void visit(@NonNull Path file, @NonNull SasFileVisitor visitor) throws IOException {
        try (SeekableByteChannel sbc = Files.newByteChannel(file, StandardOpenOption.READ);){
            SasFile.visit(sbc, visitor);
        }
    }

    public static void visit(@NonNull SeekableByteChannel sbc, @NonNull SasFileVisitor visitor) throws IOException {
        Header header = Header.parse(sbc);
        switch (visitor.onHeader(header)) {
            case CONTINUE: {
                SasFile.checkHeader(header, sbc.size());
                PageCursor pageCursor = PageCursor.of(sbc, header);
                SasFile.visitPages(header, pageCursor, visitor);
                break;
            }
        }
    }

    private static void checkHeader(Header header, long size) throws IOException {
        if ((long)header.getLength() > size) {
            throw new IOException("Header too short");
        }
        if (header.getPageLength() < 0) {
            throw new IOException("Invalid page length");
        }
        if (header.getPageCount() < 1) {
            throw new IOException("Invalid page count");
        }
    }

    private static boolean visitPages(Header header, PageCursor pageCursor, SasFileVisitor visitor) throws IOException {
        while (pageCursor.next()) {
            Bytes pageData = pageCursor.getBytes();
            PageHeader page = PageHeader.parse(pageData, header.isU64(), pageCursor.getIndex());
            switch (visitor.onPage(header, page, pageData)) {
                case CONTINUE: {
                    if (!page.getType().isKnown()) break;
                    switch (page.getType().get()) {
                        case META: 
                        case MIX: 
                        case AMD: {
                            if (SasFile.visitSubHeaderPointers(header, page, pageData, visitor)) break;
                            return false;
                        }
                        case INDEX: {
                            if (SasFile.visitRowCompEntry(header, page, pageData, visitor)) break;
                            return false;
                        }
                    }
                    break;
                }
                case SKIP_SIBLINGS: {
                    return false;
                }
                case SKIP_SUBTREE: {
                    break;
                }
                case TERMINATE: {
                    return false;
                }
            }
        }
        return true;
    }

    private static boolean visitSubHeaderPointers(Header header, PageHeader page, BytesReader pageData, SasFileVisitor visitor) {
        block6: for (int sh = 0; sh < page.getSubHeaderCount(); ++sh) {
            SubHeaderPointer pointer = SubHeaderPointer.parse(pageData, header.isU64(), page.getSubHeaderLocation(sh));
            switch (visitor.onSubHeaderPointer(header, page, pageData, pointer)) {
                case CONTINUE: {
                    continue block6;
                }
                case SKIP_SIBLINGS: {
                    return true;
                }
                case SKIP_SUBTREE: {
                    continue block6;
                }
                case TERMINATE: {
                    return false;
                }
            }
        }
        return true;
    }

    private static boolean visitRowCompEntry(Header header, PageHeader page, BytesReader pageData, SasFileVisitor visitor) {
        for (RowIndex o : RowIndex.parseAll(page, pageData, header.isU64())) {
            switch (visitor.onRowIndex(header, page, pageData, o)) {
                case CONTINUE: {
                    break;
                }
                case SKIP_SIBLINGS: {
                    return true;
                }
                case SKIP_SUBTREE: {
                    break;
                }
                case TERMINATE: {
                    return false;
                }
            }
        }
        return true;
    }

    private SasFile() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

