/*
 * Decompiled with CFR 0.152.
 */
package internal.ri.base;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.temporal.ChronoUnit;

public final class SasCalendar {
    private static final LocalDate DATE_EPOCH = LocalDate.of(1960, 1, 1);
    private static final LocalDateTime DATE_TIME_EPOCH = LocalDateTime.of(1960, 1, 1, 0, 0);

    public static LocalTime getTime(double numberOfSecondsSinceMidnight) {
        return !Double.isNaN(numberOfSecondsSinceMidnight) ? LocalTime.MIDNIGHT.plus((long)(numberOfSecondsSinceMidnight * 1000.0), ChronoUnit.MILLIS) : null;
    }

    public static LocalDateTime getDateTime(double numberOfSecondsSinceEpoch) {
        return !Double.isNaN(numberOfSecondsSinceEpoch) ? DATE_TIME_EPOCH.plus((long)(numberOfSecondsSinceEpoch * 1000.0), ChronoUnit.MILLIS) : null;
    }

    public static LocalDate getDate(double numberOfDaysSinceEpoch) {
        return !Double.isNaN(numberOfDaysSinceEpoch) ? DATE_EPOCH.plusDays((long)numberOfDaysSinceEpoch) : null;
    }

    private SasCalendar() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

